/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.properties;

import java.io.File;
import java.io.IOException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.mule.munit.remote.properties.XmlUtils;

public class DesignTimeSuitesParser {
    private static final Namespace MTF_NAMESPACE = Namespace.getNamespace("mtf", "http://www.mulesoft.org/schema/mule/mtf");
    private static final String TEST_NAME = "tooling-test";

    public boolean hasDesignTimeTests(File suiteFile) {
        try {
            SAXBuilder saxBuilder = XmlUtils.createSecureSAXBuilder();
            Document document = saxBuilder.build(suiteFile);
            Element rootElement = document.getRootElement();
            return !rootElement.getChildren(TEST_NAME, MTF_NAMESPACE).isEmpty();
        }
        catch (IOException | JDOMException e) {
            return false;
        }
    }
}

