/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static Optional<byte[]> loadFileContentFrom(URL jarFile) throws IOException {
        Optional<byte[]> optional;
        block8: {
            JarURLConnection jarConnection = (JarURLConnection)jarFile.openConnection();
            jarConnection.setUseCaches(false);
            InputStream stream = jarConnection.getInputStream();
            try {
                optional = Optional.of(IOUtils.toByteArray(stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    public static URL getUrlWithinJar(File jarFile, String filePath) throws MalformedURLException {
        return new URL("jar:" + jarFile.toURI().toString() + "!/" + filePath);
    }

    public static List<URL> getUrlsWithinJar(File file, String directory) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(directory + "/")) continue;
                urls.add(FileUtils.getUrlWithinJar(file, jarEntry.getName()));
            }
        }
        return urls;
    }
}

