/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.controller;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.mule.tools.client.standalone.controller.AbstractOSController;
import org.mule.tools.client.standalone.exception.MuleControllerException;

public class UnixController
extends AbstractOSController {
    private Executor executor;
    private OutputStream outputStream;
    private ExecuteStreamHandler executeStreamHandler;
    private ExecuteWatchdog executeWatchdog;

    public UnixController(String muleHome, int timeout) {
        super(muleHome, timeout);
    }

    @Override
    public String getMuleBin() {
        return this.muleHome + "/bin/mule";
    }

    @Override
    public int getProcessId() {
        if (this.isMuleRunning()) {
            return this.getProcessIdFromStatus();
        }
        throw new MuleControllerException("Mule Runtime is not running");
    }

    protected boolean isMuleRunning() {
        Map<Object, Object> newEnv = this.copyEnvironmentVariables();
        Executor executor = this.getExecutor();
        return this.doExecution(executor, new CommandLine(this.muleBin).addArgument("status"), newEnv) == 0;
    }

    protected int getProcessIdFromStatus() {
        Matcher matcher = STATUS_PATTERN.matcher(this.getOutputStream().toString());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        throw new MuleControllerException("bin/mule status didn't return the expected pattern: Mule(\\sEnterprise Edition)? is running \\(([0-9]+)\\)\\.");
    }

    @Override
    public int status(String ... args) {
        AbstractOSController.InternalOutputStream outputStream = new AbstractOSController.InternalOutputStream();
        int status = this.runSync("status", outputStream, args);
        return status == 0 && outputStream.toString().contains("is running") ? 0 : 1;
    }

    private ExecuteStreamHandler getExecuteStreamHandler(OutputStream outputStream) {
        if (this.executeStreamHandler == null) {
            this.executeStreamHandler = new PumpStreamHandler(outputStream);
        }
        return this.executeStreamHandler;
    }

    private ExecuteWatchdog getExecuteWatchdog(int timeout) {
        if (this.executeWatchdog == null) {
            this.executeWatchdog = new ExecuteWatchdog(timeout);
        }
        return this.executeWatchdog;
    }

    @VisibleForTesting
    protected OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return this.outputStream;
    }

    private Executor getExecutor() {
        if (this.executor == null) {
            this.executor = new DefaultExecutor();
            ExecuteWatchdog watchdog = this.getExecuteWatchdog(this.timeout);
            this.executor.setWatchdog(watchdog);
            OutputStream outputStream = this.getOutputStream();
            ExecuteStreamHandler streamHandler = this.getExecuteStreamHandler(outputStream);
            this.executor.setStreamHandler(streamHandler);
        }
        return this.executor;
    }
}

