/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.packaging.Classifier;

public class AllowedDependencyValidator {
    private static final String MULE_SERVICE = "mule-service";
    private static final String MULE_SERVER_PLUGIN = "mule-server-plugin";
    private static final List<String> CLASSIFIER_LIST = Arrays.asList(Classifier.MULE_APPLICATION.toString(), Classifier.MULE_POLICY.toString(), Classifier.MULE_DOMAIN.toString(), "mule-service", "mule-server-plugin");

    public static Boolean areDependenciesAllowed(List<ArtifactCoordinates> artifactCoordinates) throws ValidationException {
        List<ArtifactCoordinates> notAllowedDependencies = AllowedDependencyValidator.collectNotAllowedDependencies(artifactCoordinates);
        if (!notAllowedDependencies.isEmpty()) {
            StringBuilder notAllowedMessage = new StringBuilder();
            notAllowedDependencies.forEach(d -> notAllowedMessage.append(d.toString()).append(","));
            throw new ValidationException("The following dependencies are not allowed unless their scope is [provided]: " + StringUtils.removeEnd(notAllowedMessage.toString(), ","));
        }
        return true;
    }

    public static Boolean isDependencyAllowed(ArtifactCoordinates artifactCoordinates) {
        if (StringUtils.isNotBlank(artifactCoordinates.getClassifier())) {
            if (artifactCoordinates.getClassifier().equals(Classifier.MULE_DOMAIN_BUNDLE.toString())) {
                return false;
            }
            for (String classifier : CLASSIFIER_LIST) {
                if (!artifactCoordinates.getClassifier().startsWith(classifier) || artifactCoordinates.getScope().equals("provided")) continue;
                return false;
            }
        }
        return true;
    }

    private static List<ArtifactCoordinates> collectNotAllowedDependencies(List<ArtifactCoordinates> artifactCoordinates) {
        ArrayList<ArtifactCoordinates> notAllowedDependencies = new ArrayList<ArtifactCoordinates>();
        for (ArtifactCoordinates a : artifactCoordinates) {
            if (AllowedDependencyValidator.isDependencyAllowed(a).booleanValue()) continue;
            notAllowedDependencies.add(a);
        }
        return notAllowedDependencies;
    }
}

