/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.internal.MuleMavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.NotParameterizedClassLoaderModel;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.mule.tools.api.muleclassloader.model.ApplicationClassLoaderModelAssembler;
import org.mule.tools.api.muleclassloader.model.resolver.AdditionalPluginDependenciesResolver;
import org.mule.tools.api.muleclassloader.model.resolver.ApplicationDependencyResolver;
import org.mule.tools.api.muleclassloader.model.resolver.MulePluginClassloaderModelResolver;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.sources.ContentGeneratorFactory;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.repository.ArtifactInstaller;
import org.mule.tools.api.repository.MuleMavenPluginClientBuilder;
import org.mule.tools.api.repository.RepositoryGenerator;
import org.mule.tools.api.util.DependencyProject;
import org.mule.tools.api.util.FileJarExplorer;
import org.mule.tools.api.util.MavenComponents;
import org.mule.tools.api.util.MavenPackagerLog;
import org.mule.tools.api.util.MavenProjectBuilder;
import org.mule.tools.api.util.MavenProjectInformation;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.MulePluginsCompatibilityValidator;
import org.mule.tools.api.validation.resolver.MulePluginResolver;

public class SourcesProcessor {
    protected final MulePluginsCompatibilityValidator mulePluginsCompatibilityValidator = new MulePluginsCompatibilityValidator();
    protected MavenComponents mavenComponents;

    public SourcesProcessor(MavenComponents mavenComponents) {
        Preconditions.checkArgument(mavenComponents != null, "The mavenComponents must not be null");
        this.mavenComponents = mavenComponents;
    }

    @Deprecated
    public void process(boolean prettyPrinting, boolean lightweightPackage, boolean useLocalRepository, boolean testJar, File repositoryOutputDirectory, File classloaderOutputDirectory) throws Exception {
        this.process(prettyPrinting, lightweightPackage, useLocalRepository, testJar, repositoryOutputDirectory, classloaderOutputDirectory, Optional.empty());
    }

    public void process(boolean prettyPrinting, boolean lightweightPackage, boolean useLocalRepository, boolean testJar, File repositoryOutputDirectory, File classloaderOutputDirectory, Optional<MavenReactorResolver> mavenReactorResolver) throws Exception {
        boolean isLightWeightUsingLocalRepository;
        boolean isHeavyWeight = !lightweightPackage;
        boolean bl = isLightWeightUsingLocalRepository = lightweightPackage && useLocalRepository;
        if (isLightWeightUsingLocalRepository || isHeavyWeight) {
            ApplicationGAVModel appGAV = new ApplicationGAVModel(this.mavenComponents.getProject().getGroupId(), this.mavenComponents.getProject().getArtifactId(), this.mavenComponents.getProject().getVersion());
            RepositoryGenerator repositoryGenerator = new RepositoryGenerator(this.mavenComponents.getProject().getFile(), repositoryOutputDirectory, new ArtifactInstaller(new MavenPackagerLog(this.mavenComponents.getLog())), this.getClassLoaderModelAssembler(), appGAV, this.mavenComponents.getSession().getRequest().getActiveProfiles());
            ClassLoaderModel classLoaderModel = repositoryGenerator.generate(lightweightPackage, useLocalRepository, prettyPrinting, testJar, mavenReactorResolver);
            for (SharedLibraryDependency sharedLibraryDependency : this.mavenComponents.getSharedLibraries()) {
                classLoaderModel.getDependencies().stream().filter(dep -> dep.getArtifactCoordinates().getArtifactId().equals(sharedLibraryDependency.getArtifactId()) && dep.getArtifactCoordinates().getGroupId().equals(sharedLibraryDependency.getGroupId())).findFirst().ifPresent(dep -> {
                    if (!this.validateMuleRuntimeSharedLibrary(dep.getArtifactCoordinates().getArtifactId(), dep.getArtifactCoordinates().getGroupId())) {
                        dep.setShared(true);
                    }
                });
            }
            Project project = this.getProject(classLoaderModel);
            this.mulePluginsCompatibilityValidator.validate(this.getResolver(project).resolve());
            if (isLightWeightUsingLocalRepository) {
                classLoaderModel = new NotParameterizedClassLoaderModel(classLoaderModel);
            }
            ((MuleContentGenerator)this.getContentGenerator(testJar, lightweightPackage)).createApplicationClassLoaderModelJsonFile(classLoaderModel, prettyPrinting, classloaderOutputDirectory);
        }
    }

    protected ApplicationClassLoaderModelAssembler getClassLoaderModelAssembler() {
        MuleMavenClient mavenClient = this.getMavenClient();
        return new ApplicationClassLoaderModelAssembler(new ApplicationDependencyResolver(mavenClient), new MulePluginClassloaderModelResolver(mavenClient), new AdditionalPluginDependenciesResolver(mavenClient, this.mavenComponents.getAdditionalPluginDependencies() == null ? new ArrayList() : this.mavenComponents.getAdditionalPluginDependencies(), new File(this.mavenComponents.getOutputDirectory(), "temp")), new FileJarExplorer());
    }

    protected final boolean validateMuleRuntimeSharedLibrary(String groupId, String artifactId) {
        if ("org.mule.runtime".equals(groupId) || "com.mulesoft.mule.runtime.modules".equals(groupId)) {
            this.mavenComponents.getLog().warn((CharSequence)("Shared library '" + groupId + ":" + artifactId + "' is a Mule Runtime dependency. It will not be shared by the app in order to avoid classloading issues. Please consider removing it, or at least not putting it as a sharedLibrary."));
            return true;
        }
        return false;
    }

    protected Project getProject(final ClassLoaderModel classLoaderModel) {
        final DependencyProject dependencyProject = new DependencyProject(this.mavenComponents.getProject());
        return new Project(){

            @Override
            public List<ArtifactCoordinates> getDirectDependencies() {
                return classLoaderModel.getDependencies().stream().map(Artifact::getArtifactCoordinates).collect(Collectors.toList());
            }

            @Override
            public List<BundleDependency> getBundleDependencies() {
                return dependencyProject.getBundleDependencies();
            }
        };
    }

    protected ContentGenerator getContentGenerator(boolean testJar, boolean lightweightPackage) {
        return ContentGeneratorFactory.create(this.getProjectInformation(testJar, lightweightPackage));
    }

    protected MulePluginResolver getResolver(Project project) {
        MavenProjectBuilder builder = new MavenProjectBuilder(this.mavenComponents.getLog(), this.mavenComponents.getSession(), this.mavenComponents.getProjectBuilder(), this.mavenComponents.getRepositorySystem(), this.mavenComponents.getLocalRepository(), this.mavenComponents.getRemoteArtifactRepositories());
        return new MulePluginResolver(builder, project);
    }

    protected ProjectInformation getProjectInformation(boolean testJar, boolean lightweightPackage) {
        return MavenProjectInformation.getProjectInformation(this.mavenComponents.getSession(), this.mavenComponents.getProject(), this.mavenComponents.getProjectBaseFolder(), testJar, null, this.getClassifier(testJar, lightweightPackage));
    }

    protected String getClassifier(boolean testJar, boolean lightweightPackage) {
        return this.getPackagingType().resolveClassifier(this.mavenComponents.getClassifier(), lightweightPackage, testJar);
    }

    protected PackagingType getPackagingType() {
        return PackagingType.fromString(this.mavenComponents.getProject().getPackaging());
    }

    protected MuleMavenClient getMavenClient() {
        MavenExecutionRequest request = this.mavenComponents.getSession().getRequest();
        List remoteRepositories = RepositoryUtils.toRepos(this.mavenComponents.getRemoteArtifactRepositories());
        return new MuleMavenPluginClientBuilder(new MavenPackagerLog(this.mavenComponents.getLog())).withRemoteRepositories(remoteRepositories).withLocalRepository(request.getLocalRepositoryPath()).withUserSettings(request.getUserSettingsFile()).withGlobalSettings(request.getGlobalSettingsFile()).withUserProperties(request.getUserProperties()).withActiveProfiles(request.getActiveProfiles()).withInactiveProfiles(request.getInactiveProfiles()).build();
    }
}

