/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.mule.tools.api.muleclassloader.model.resolver.Plugin;

public class MavenComponents {
    private MavenProject project;
    private File outputDirectory;
    private MavenSession session;
    private List<SharedLibraryDependency> sharedLibraries;
    private ProjectBuilder projectBuilder;
    private RepositorySystem repositorySystem;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private String classifier;
    private List<Plugin> additionalPluginDependencies;
    private File projectBaseFolder;
    private Log log;

    public MavenComponents withLog(Log log) {
        Preconditions.checkArgument(log != null, "The log must not be null");
        this.log = log;
        return this;
    }

    public MavenComponents withProject(MavenProject project) {
        Preconditions.checkArgument(project != null, "The project must not be null");
        this.project = project;
        return this;
    }

    public MavenComponents withOutputDirectory(File outputDirectory) {
        Preconditions.checkArgument(outputDirectory != null, "The outputDirectory must not be null");
        this.outputDirectory = outputDirectory;
        return this;
    }

    public MavenComponents withSession(MavenSession session) {
        Preconditions.checkArgument(session != null, "The session must not be null");
        this.session = session;
        return this;
    }

    public MavenComponents withSharedLibraries(List<SharedLibraryDependency> sharedLibraries) {
        Preconditions.checkArgument(sharedLibraries != null, "The sharedLibraries must not be null");
        this.sharedLibraries = sharedLibraries;
        return this;
    }

    public MavenComponents withProjectBuilder(ProjectBuilder projectBuilder) {
        Preconditions.checkArgument(projectBuilder != null, "The projectBuilder must not be null");
        this.projectBuilder = projectBuilder;
        return this;
    }

    public MavenComponents withRepositorySystem(RepositorySystem repositorySystem) {
        Preconditions.checkArgument(repositorySystem != null, "The repositorySystem must not be null");
        this.repositorySystem = repositorySystem;
        return this;
    }

    public MavenComponents withLocalRepository(ArtifactRepository localRepository) {
        Preconditions.checkArgument(localRepository != null, "The localRepository must not be null");
        this.localRepository = localRepository;
        return this;
    }

    public MavenComponents withRemoteArtifactRepositories(List<ArtifactRepository> remoteArtifactRepositories) {
        Preconditions.checkArgument(remoteArtifactRepositories != null, "The remoteArtifactRepositories must not be null");
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        return this;
    }

    public MavenComponents withClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public MavenComponents withAdditionalPluginDependencies(List<Plugin> additionalPluginDependencies) {
        this.additionalPluginDependencies = additionalPluginDependencies;
        return this;
    }

    public MavenComponents withProjectBaseFolder(File projectBaseFolder) {
        Preconditions.checkArgument(projectBaseFolder != null, "The projectBaseFolder must not be null");
        this.projectBaseFolder = projectBaseFolder;
        return this;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public List<SharedLibraryDependency> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public ProjectBuilder getProjectBuilder() {
        return this.projectBuilder;
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public List<ArtifactRepository> getRemoteArtifactRepositories() {
        return this.remoteArtifactRepositories;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public List<Plugin> getAdditionalPluginDependencies() {
        return this.additionalPluginDependencies;
    }

    public File getProjectBaseFolder() {
        return this.projectBaseFolder;
    }

    public Log getLog() {
        return this.log;
    }
}

