/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.muleclassloader.model.resolver;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.muleclassloader.model.resolver.Plugin;
import org.mule.tools.api.muleclassloader.model.util.ArtifactUtils;
import org.mule.tools.api.packager.packaging.Classifier;

public class AdditionalPluginDependenciesResolver {
    protected static final String MULE_EXTENSIONS_PLUGIN_GROUP_ID = "org.mule.runtime.plugins";
    protected static final String MULE_EXTENSIONS_PLUGIN_ARTIFACT_ID = "mule-extensions-maven-plugin";
    protected static final String MULE_MAVEN_PLUGIN_GROUP_ID = "org.mule.tools.maven";
    protected static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    protected static final String ADDITIONAL_PLUGIN_DEPENDENCIES_ELEMENT = "additionalPluginDependencies";
    protected static final String ADDITIONAL_DEPENDENCIES_ELEMENT = "additionalDependencies";
    protected static final String GROUP_ID_ELEMENT = "groupId";
    protected static final String ARTIFACT_ID_ELEMENT = "artifactId";
    protected static final String VERSION_ELEMENT = "version";
    protected static final String PLUGIN_ELEMENT = "plugin";
    protected static final String DEPENDENCY_ELEMENT = "dependency";
    private final MavenClient mavenClient;
    private final List<AdditionalPluginDependencies> pluginsWithAdditionalDependencies;
    private final File temporaryFolder;

    public AdditionalPluginDependenciesResolver(MavenClient mavenClient, List<Plugin> additionalPluginDependencies, File temporaryFolder) {
        this.mavenClient = mavenClient;
        this.pluginsWithAdditionalDependencies = additionalPluginDependencies.stream().map(this::toAdditionalPluginDependencies).collect(Collectors.toCollection(ArrayList::new));
        this.temporaryFolder = temporaryFolder;
    }

    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> applicationDependencies, Collection<ClassLoaderModel> mulePluginsClassLoaderModels) {
        this.addPluginDependenciesAdditionalLibraries(applicationDependencies);
        LinkedHashMap<BundleDependency, List<BundleDependency>> pluginsWithAdditionalDeps = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (AdditionalPluginDependencies pluginWithAdditionalDependencies : this.pluginsWithAdditionalDependencies) {
            BundleDependency pluginBundleDependency = this.getPluginBundleDependency(pluginWithAdditionalDependencies, applicationDependencies);
            List<Artifact> pluginDependencies = this.getPluginDependencies(pluginWithAdditionalDependencies, mulePluginsClassLoaderModels);
            List<BundleDependency> additionalDependencies = this.resolveDependencies(pluginWithAdditionalDependencies.getAdditionalDependencies().stream().filter(additionalDep -> pluginDependencies.stream().noneMatch(this.areSameArtifact((BundleDescriptor)additionalDep))).collect(Collectors.toList()));
            if (additionalDependencies.isEmpty()) continue;
            pluginsWithAdditionalDeps.put(pluginBundleDependency, additionalDependencies);
        }
        return pluginsWithAdditionalDeps;
    }

    private List<BundleDependency> resolveDependencies(List<BundleDescriptor> additionalDependencies) {
        return this.mavenClient.resolveArtifactDependencies(additionalDependencies, Optional.of(this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.empty());
    }

    private BundleDependency getPluginBundleDependency(AdditionalPluginDependencies plugin, List<BundleDependency> mulePlugins) {
        Predicate<BundleDependency> match = dependency -> Stream.of(Pair.of(dependency.getDescriptor().getGroupId(), plugin.getGroupId()), Pair.of(dependency.getDescriptor().getArtifactId(), plugin.getArtifactId())).allMatch(pair -> StringUtils.equals((CharSequence)pair.getLeft(), (CharSequence)pair.getRight()));
        return mulePlugins.stream().filter(match).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Declared additional dependencies for a plugin not present: " + plugin))));
    }

    private List<Artifact> getPluginDependencies(AdditionalPluginDependencies plugin, Collection<ClassLoaderModel> mulePluginsClassLoaderModels) {
        Function<ArtifactCoordinates, Boolean> mapper = coordinates -> Stream.of(Pair.of(coordinates.getGroupId(), plugin.getGroupId()), Pair.of(coordinates.getArtifactId(), plugin.getArtifactId())).allMatch(pair -> StringUtils.equals((CharSequence)pair.getLeft(), (CharSequence)pair.getRight()));
        Predicate<ClassLoaderModel> match = classLoaderModel -> Optional.ofNullable(classLoaderModel.getArtifactCoordinates()).map(mapper).orElse(false);
        return mulePluginsClassLoaderModels.stream().filter(match).findFirst().map(ClassLoaderModel::getDependencies).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find ClassLoaderModel resolved for plugin: " + plugin))));
    }

    private Predicate<Artifact> areSameArtifact(BundleDescriptor descriptor) {
        return artifact -> StringUtils.equals(descriptor.getArtifactId(), artifact.getArtifactCoordinates().getArtifactId()) && StringUtils.equals(descriptor.getGroupId(), artifact.getArtifactCoordinates().getGroupId()) && StringUtils.equals(descriptor.getVersion(), artifact.getArtifactCoordinates().getVersion());
    }

    private void addPluginDependenciesAdditionalLibraries(List<BundleDependency> applicationDependencies) {
        List<BundleDependency> plugins = applicationDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getClassifier().map(Classifier.MULE_PLUGIN::equals).orElse(false)).collect(Collectors.toList());
        Collection<AdditionalPluginDependencies> additionalDependencies = this.resolveAdditionalDependenciesFromMulePlugins(plugins);
        this.pluginsWithAdditionalDependencies.addAll(additionalDependencies.stream().filter(this::isNotRedefinedAtApplicationLevel).collect(Collectors.toList()));
    }

    private Collection<AdditionalPluginDependencies> resolveAdditionalDependenciesFromMulePlugins(List<BundleDependency> mulePlugins) {
        BiPredicate<BundleDescriptor, BundleDescriptor> match = (obj00, obj01) -> Stream.of(BundleDescriptor::getGroupId, BundleDescriptor::getArtifactId, BundleDescriptor::getType, value -> value.getClassifier().orElse(null)).allMatch(getter -> StringUtils.equals((CharSequence)getter.apply(obj00), (CharSequence)getter.apply(obj01)));
        HashMap additionalDependencies = new HashMap();
        mulePlugins.stream().map(mulePlugin -> new File(mulePlugin.getBundleUri())).filter(file -> this.mavenClient.getRawPomModel((File)file).getPackaging().equals("mule-application")).map(file -> this.mavenClient.getEffectiveModel((File)file, Optional.of(this.temporaryFolder)).getPomFile()).filter(Optional::isPresent).map(Optional::get).forEach(pomFile -> MavenPomParserProvider.discoverProvider().createMavenPomParserClient(pomFile.toPath()).getPomAdditionalPluginDependenciesForArtifacts().values().forEach(mavenPlugin -> {
            String artifact = mavenPlugin.getGroupId() + ":" + mavenPlugin.getArtifactId();
            AdditionalPluginDependencies alreadyDefinedDependencies = (AdditionalPluginDependencies)additionalDependencies.get(artifact);
            if (Objects.nonNull(alreadyDefinedDependencies)) {
                LinkedList<BundleDescriptor> effectiveDependencies = new LinkedList<BundleDescriptor>(alreadyDefinedDependencies.getAdditionalDependencies());
                mavenPlugin.getAdditionalDependencies().forEach(additionalDependency -> {
                    boolean addDependency = true;
                    for (BundleDescriptor effectiveDependency : effectiveDependencies) {
                        if (!match.test(effectiveDependency, (BundleDescriptor)additionalDependency)) continue;
                        if (this.isNewerVersion(additionalDependency.getVersion(), effectiveDependency.getVersion())) {
                            effectiveDependencies.remove(effectiveDependency);
                            break;
                        }
                        addDependency = false;
                        break;
                    }
                    if (addDependency) {
                        effectiveDependencies.add((BundleDescriptor)additionalDependency);
                    }
                });
                additionalDependencies.replace(artifact, new AdditionalPluginDependencies(alreadyDefinedDependencies, effectiveDependencies));
            } else {
                additionalDependencies.put(mavenPlugin.getGroupId() + ":" + mavenPlugin.getArtifactId(), mavenPlugin);
            }
        }));
        return additionalDependencies.values();
    }

    private boolean isNewerVersion(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).isGreaterThan(new Semver(dependencyB, Semver.SemverType.LOOSE));
        }
        catch (IllegalArgumentException e) {
            return dependencyA.compareTo(dependencyB) > 0;
        }
    }

    private boolean isNotRedefinedAtApplicationLevel(AdditionalPluginDependencies additionalPluginDependencies) {
        BiPredicate<AdditionalPluginDependencies, AdditionalPluginDependencies> match = (obj00, obj01) -> Stream.of(AdditionalPluginDependencies::getGroupId, AdditionalPluginDependencies::getArtifactId).allMatch(getter -> StringUtils.equals((CharSequence)getter.apply(obj00), (CharSequence)getter.apply(obj01)));
        return this.pluginsWithAdditionalDependencies.stream().noneMatch(additionalDependency -> match.test(additionalPluginDependencies, (AdditionalPluginDependencies)additionalDependency));
    }

    private AdditionalPluginDependencies toAdditionalPluginDependencies(Plugin plugin) {
        return new AdditionalPluginDependencies(plugin.getGroupId(), plugin.getArtifactId(), Optional.ofNullable(plugin.getAdditionalDependencies()).map(Collection::stream).orElse(Stream.empty()).map(ArtifactUtils::toBundleDescriptor).collect(Collectors.toList()));
    }
}

