/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.common.util.IllegalPortDefinitionException;
import org.mule.munit.common.util.RunnerPortProvider;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.MuleDxMunitLock;
import org.mule.munit.remote.api.client.RunnerClient;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.DebuggerConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.Container;
import org.mule.munit.remote.container.ContainerFactoryException;
import org.mule.munit.remote.container.SuiteRunDispatcher;
import org.mule.munit.remote.container.SuiteRunDispatcherListener;
import org.mule.munit.remote.container.model.SuiteDeployment;
import org.mule.munit.remote.container.model.SuiteRun;
import org.mule.munit.remote.coverage.CoverageManager;
import org.mule.munit.remote.coverage.model.ApplicationCoverageReport;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.properties.Parameterization;
import org.mule.munit.remote.properties.deploy.DeploymentProperties;
import org.mule.munit.remote.properties.deploy.MuleRuntimeDeploymentProperties;
import org.mule.munit.remote.properties.deploy.TemporaryFolderProperties;
import org.mule.munit.remote.runtime.utils.MuleApplicationModel;
import org.mule.munit.remote.runtime.utils.MuleApplicationModelJsonSerializer;
import org.mule.munit.remote.runtime.utils.Product;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSuiteRunDispatcher
implements SuiteRunDispatcher {
    public static final String MUNIT_SUITE_TIMEOUT_PROPERTY = "munit.suite.timeout";
    private static final Long DEFAULT_TIMEOUT = 1800000L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ContainerSuiteRunDispatcher.class);
    private final Container container;
    private final RunConfiguration runConfig;
    private final MuleApplicationModel originalMuleApplicationModel;
    private final Set<SuiteRun> suiteRuns;
    private final Collection<DeploymentProperties> deploymentProperties;
    private final File applicationDirectory;
    private final int munitRunnerPort;
    private final CoverageManager coverageManager;
    private final List<SuiteRunDispatcherListener> suiteRunDispatcherListeners = new ArrayList<SuiteRunDispatcherListener>();

    public ContainerSuiteRunDispatcher(Container container, RunConfiguration runConfiguration, Set<SuiteRun> suiteRuns, File applicationDirectory) {
        this.container = container;
        this.runConfig = runConfiguration;
        this.suiteRuns = suiteRuns;
        this.applicationDirectory = applicationDirectory;
        this.originalMuleApplicationModel = this.getOriginalApplicationModel();
        this.deploymentProperties = this.getDeploymentProperties();
        this.munitRunnerPort = this.getPort();
        this.coverageManager = this.buildCoverageManager(this.runConfig.getCoverageConfiguration());
    }

    protected Integer getPort() throws ContainerFactoryException {
        try {
            return new RunnerPortProvider().getPort();
        }
        catch (IllegalPortDefinitionException e) {
            throw new ContainerFactoryException(e.getMessage(), e);
        }
    }

    private MuleApplicationModel getOriginalApplicationModel() {
        try {
            File muleArtifactJsonFile = this.getMuleArtifactJsonFile();
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(IOUtils.toString(muleArtifactJsonFile.toURI(), Charset.defaultCharset()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Collection<DeploymentProperties> getDeploymentProperties() {
        ArrayList<DeploymentProperties> deploymentProperties = new ArrayList<DeploymentProperties>();
        deploymentProperties.add(new MuleRuntimeDeploymentProperties(this.runConfig));
        deploymentProperties.add(new TemporaryFolderProperties());
        return deploymentProperties;
    }

    private File getMuleArtifactJsonFile() {
        return Paths.get(this.applicationDirectory.toURI()).resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSuites(RemoteRunEventListener listener) throws DeploymentException {
        if (this.suiteRuns.stream().noneMatch(this::shouldRunSuite)) {
            LOGGER.info("Suite run for suites " + this.suiteRuns + " will not start since no suites will run");
            return;
        }
        try {
            if (!this.container.isJvmVersionSupported()) {
                LOGGER.info("The current java version is not supported by the runtime version [" + this.container.getMuleContainerVersion() + "].");
                return;
            }
            this.getCoverageManager().ifPresent(CoverageManager::startCoverageServer);
            this.container.start();
            this.container.deployDomain();
            Collection<SuiteDeployment> suiteDeployments = this.generateSuiteDeployments();
            Map<String, Object> initialProperties = this.getInitialProperties(suiteDeployments, this.runConfig.getClearParameters());
            this.waitForDebuggerClient();
            for (SuiteDeployment suiteDeployment : suiteDeployments) {
                this.performSuiteDeploy(listener, suiteDeployment, initialProperties);
            }
        }
        catch (SkipAfterFailureException e) {
            LOGGER.debug("Skipped running suites since skipAfterFailure is on");
        }
        finally {
            try {
                this.container.stop();
            }
            finally {
                this.getCoverageManager().ifPresent(CoverageManager::stopCoverageServer);
                this.getCoverageManager().ifPresent(manager -> this.sendCoverageReport((CoverageManager)manager, listener));
                this.suiteRunDispatcherListeners.forEach(SuiteRunDispatcherListener::onFinish);
            }
        }
    }

    private Collection<SuiteDeployment> generateSuiteDeployments() {
        ArrayList<SuiteDeployment> suiteDeployments = new ArrayList<SuiteDeployment>();
        suiteDeployments.addAll(this.getParameterizedDeployments());
        this.getDesignTimeSuitesDeployment().ifPresent(suiteDeployments::add);
        this.getRuntimeSuitesDeployment().ifPresent(suiteDeployments::add);
        return suiteDeployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSuiteDeploy(RemoteRunEventListener listener, SuiteDeployment suiteDeployment, Map<String, Object> initialProperties) throws SkipAfterFailureException {
        Set<SuiteRun> suiteRuns = suiteDeployment.getSuiteRuns();
        if (suiteRuns.stream().noneMatch(this::shouldRunSuite)) {
            LOGGER.info("Suite run for suites " + suiteRuns + " will not start since no suites will run");
            return;
        }
        Map<String, Object> systemProperties = this.getSystemProperties(initialProperties, suiteDeployment);
        try {
            this.removeSuitesThatWontRun(suiteRuns);
            this.container.deployApplication(suiteDeployment.isEnableXmlValidations(), systemProperties);
            for (SuiteRun suiteRun : suiteRuns) {
                if (this.shouldRunSuite(suiteRun)) {
                    String parameterizationName;
                    String suitePath = suiteRun.getSuitePath();
                    boolean success = this.runSuite(this.runConfig, listener, suitePath, parameterizationName = this.getParameterizationName(suiteRun));
                    if (success || !this.runConfig.isSkipAfterFailure().booleanValue()) continue;
                    throw new SkipAfterFailureException();
                }
                this.showSuiteSkippedMessage(suiteRun);
            }
        }
        catch (DeploymentException e) {
            if (suiteRuns.size() > 1) {
                listener.notifyContainerFailure(StackTraceUtil.getStackTrace(e));
            } else {
                SuiteRun suiteRun = suiteRuns.iterator().next();
                listener.notifyContainerFailure(suiteRun.getSuitePath(), this.getParameterizationName(suiteRun), StackTraceUtil.getStackTrace(e));
            }
        }
        finally {
            try {
                this.container.undeployApplication(systemProperties);
            }
            catch (Exception e) {
                LOGGER.error("Exception undeploying application.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runSuite(RunConfiguration runConfig, RemoteRunEventListener listener, String suitePath, String parameterizationName) {
        Future<Boolean> clientTask = null;
        try {
            RunnerClient runnerClient = this.getRunnerClient(listener);
            runnerClient.sendSuiteRunInfo(runConfig.getRunToken(), suitePath, parameterizationName, runConfig.getTestNames(), runConfig.getTestNamesWithSuite(), runConfig.getTags());
            ExecutorService executor = Executors.newCachedThreadPool();
            clientTask = executor.submit(runnerClient::receiveAndNotify);
            boolean bl = clientTask.get(this.getSuiteTimeout(), TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            listener.notifyContainerFailure(suitePath, parameterizationName, StackTraceUtil.getStackTrace(e));
            boolean executor = false;
            return executor;
        }
        catch (ExecutionException e) {
            listener.notifyContainerFailure(suitePath, parameterizationName, StackTraceUtil.getStackTrace(e.getCause()));
            boolean executor = false;
            return executor;
        }
        catch (TimeoutException e) {
            String timeoutMessage = "Suite timeout after " + this.getSuiteTimeout() + " milliseconds. To change the default timeout use the " + MUNIT_SUITE_TIMEOUT_PROPERTY + " property";
            LOGGER.error(timeoutMessage, e);
            listener.notifyUnexpectedError(timeoutMessage);
            boolean bl = false;
            return bl;
        }
        finally {
            if (clientTask != null) {
                clientTask.cancel(true);
            }
        }
    }

    protected RunnerClient getRunnerClient(RemoteRunEventListener listener) throws IOException {
        return new RunnerClient(this.munitRunnerPort, listener);
    }

    private void removeSuitesThatWontRun(Set<SuiteRun> suiteRuns) {
        Set skippedSuites = suiteRuns.stream().filter(this::shouldNotRunSuite).map(SuiteRun::getSuitePath).collect(Collectors.toSet());
        if (!skippedSuites.isEmpty()) {
            LOGGER.info("Suites " + skippedSuites + " will be skipped");
        }
        Set suitesToRun = suiteRuns.stream().filter(this::shouldRunSuite).map(SuiteRun::getSuitePath).collect(Collectors.toSet());
        Set<String> newConfigs = this.originalMuleApplicationModel.getConfigs().stream().filter(config -> this.isNonSuiteConfigFile((String)config) || suitesToRun.contains(config)).collect(Collectors.toSet());
        try {
            MuleApplicationModel muleApplicationModel = ContainerSuiteRunDispatcher.overrideConfigs(this.originalMuleApplicationModel, newConfigs);
            String newMuleApplicationModelString = new MuleApplicationModelJsonSerializer().serialize(muleApplicationModel);
            FileUtils.write(this.getMuleArtifactJsonFile(), (CharSequence)newMuleApplicationModelString, Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalStateException("An error occurred while regenerating the Mule Application Model", e);
        }
    }

    private boolean isNonSuiteConfigFile(String config) {
        return !this.runConfig.getAllSuitePaths().contains(config);
    }

    private Map<String, Object> getSystemProperties(Map<String, Object> initialProperties, SuiteDeployment suiteDeployment) {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>(initialProperties);
        this.deploymentProperties.forEach(properties -> systemProperties.putAll((Map)properties.get()));
        systemProperties.putAll(suiteDeployment.getSystemProperties());
        return systemProperties;
    }

    private void showSuiteSkippedMessage(SuiteRun suiteRun) {
        String message = "Suite " + suiteRun.getSuitePath() + " will not be deployed: ";
        if (suiteRun.isIgnored()) {
            message = message + "Suite is ignored";
        } else if (!this.isCurrentRuntimeAtLeastMinVersion(suiteRun).booleanValue()) {
            message = message + String.format("Current runtime version [%s] is lower that suite's minMuleVersion [%s]", this.getRuntimeVersion(), suiteRun.getMinMuleVersion().orElse("N/A"));
        } else if (!this.isSuiteFiltered(suiteRun)) {
            message = message + "Suite was filtered from running";
        } else if (!this.isCurrentRuntimeProductAllowedToRun(suiteRun)) {
            message = message + String.format("Suite is expected to run only with runtime product [%s] and the current runtime is [%s]", new Object[]{suiteRun.getRequiredProduct(), this.getContainerRuntimeProduct()});
        }
        LOGGER.info(message);
    }

    private boolean shouldRunSuite(SuiteRun suiteRun) {
        return !suiteRun.isIgnored() && this.isCurrentRuntimeAtLeastMinVersion(suiteRun) != false && this.isSuiteFiltered(suiteRun) && this.isCurrentRuntimeProductAllowedToRun(suiteRun);
    }

    private boolean shouldNotRunSuite(SuiteRun suiteRun) {
        return !this.shouldRunSuite(suiteRun);
    }

    private Boolean isCurrentRuntimeAtLeastMinVersion(SuiteRun suiteRun) {
        return suiteRun.getMinMuleVersion().map(minMuleVersion -> MuleRuntimeDeploymentProperties.isAtLeastMinMuleVersion(this.getRuntimeVersion(), minMuleVersion)).orElse(true);
    }

    private boolean isSuiteFiltered(SuiteRun suiteRun) {
        return this.runConfig.getSuitePaths().contains(suiteRun.getSuitePath());
    }

    private boolean isCurrentRuntimeProductAllowedToRun(SuiteRun suiteRun) {
        Product containerRuntimeProduct = this.getContainerRuntimeProduct();
        Product currentSuiteRequiredProduct = suiteRun.getRequiredProduct();
        return currentSuiteRequiredProduct != Product.MULE_EE || containerRuntimeProduct == Product.MULE_EE;
    }

    private Map<String, Object> getInitialProperties(Collection<SuiteDeployment> suiteDeployments, Boolean clearParameters) {
        HashMap<String, Object> initialProperties = new HashMap<String, Object>();
        if (!clearParameters.booleanValue()) {
            suiteDeployments.forEach(suite -> initialProperties.putAll(suite.getSystemProperties()));
        }
        return initialProperties;
    }

    public static MuleApplicationModel overrideConfigs(MuleApplicationModel originalMuleApplicationModel, Set<String> configs) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setConfigs((Set)configs);
        builder.setMinMuleVersion(originalMuleApplicationModel.getMinMuleVersion());
        builder.setName(originalMuleApplicationModel.getName());
        builder.setRedeploymentEnabled(true);
        builder.setRequiredProduct(originalMuleApplicationModel.getRequiredProduct());
        builder.setSecureProperties((List)originalMuleApplicationModel.getSecureProperties());
        builder.withBundleDescriptorLoader(originalMuleApplicationModel.getBundleDescriptorLoader());
        builder.withClassLoaderModelDescriptorLoader(originalMuleApplicationModel.getClassLoaderModelLoaderDescriptor());
        return (MuleApplicationModel)builder.build();
    }

    private List<SuiteDeployment> getParameterizedDeployments() {
        return this.suiteRuns.stream().filter(suiteRun -> suiteRun.getParameterization().isPresent()).map(this::createParameterizedSuiteDeployment).collect(Collectors.toList());
    }

    private SuiteDeployment createParameterizedSuiteDeployment(SuiteRun suiteRun) {
        Parameterization parameterization = suiteRun.getParameterization().get();
        return SuiteDeployment.builder().withSuiteRuns(Collections.singleton(suiteRun)).withSystemProperties(parameterization.getParameters()).withEnableXmlValidations(!suiteRun.isDesignTime()).build();
    }

    private Set<SuiteRun> getDesignTimeSuites() {
        return this.suiteRuns.stream().filter(SuiteRun::isDesignTime).collect(Collectors.toSet());
    }

    private Optional<SuiteDeployment> getDesignTimeSuitesDeployment() {
        Set<SuiteRun> designTimeSuites = this.getDesignTimeSuites().stream().filter(suiteRun -> !suiteRun.getParameterization().isPresent()).collect(Collectors.toSet());
        if (designTimeSuites.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SuiteDeployment.builder().withSuiteRuns(designTimeSuites).withEnableXmlValidations(false).build());
    }

    private Optional<SuiteDeployment> getRuntimeSuitesDeployment() {
        Set<SuiteRun> runtimeSuites = this.suiteRuns.stream().filter(suiteRun -> !suiteRun.isDesignTime()).filter(suiteRun -> !suiteRun.getParameterization().isPresent()).collect(Collectors.toSet());
        if (runtimeSuites.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SuiteDeployment.builder().withSuiteRuns(runtimeSuites).withEnableXmlValidations(true).build());
    }

    private String getParameterizationName(SuiteRun suiteRun) {
        return suiteRun.getParameterization().map(Parameterization::getParameterizationName).orElse("");
    }

    private String getRuntimeVersion() {
        return this.container.getMuleContainerVersion();
    }

    private Product getContainerRuntimeProduct() {
        String containerRuntimeProduct = this.runConfig.getContainerConfiguration().getProduct();
        if (containerRuntimeProduct == null) {
            return null;
        }
        if (containerRuntimeProduct.equals(org.mule.runtime.module.embedded.api.Product.MULE_FRAMEWORK.name())) {
            return Product.MULE_EE;
        }
        return Product.valueOf(containerRuntimeProduct);
    }

    private CoverageManager buildCoverageManager(CoverageConfiguration coverageConfiguration) {
        if (coverageConfiguration == null || !coverageConfiguration.isRunCoverage().booleanValue()) {
            return null;
        }
        Integer coverageServerPort = coverageConfiguration.getCoveragePort();
        Boolean randomizeCoveragePort = coverageConfiguration.isRandomizeCoveragePort();
        CoverageManager coverageManager = new CoverageManager(randomizeCoveragePort, coverageServerPort, coverageConfiguration.isRunCoverage(), coverageConfiguration.getSuitePaths());
        coverageManager.setIgnoreFlows(Optional.ofNullable(coverageConfiguration.getIgnoredFlowNames()).orElse(Collections.emptySet()));
        coverageManager.setIgnoreFiles(Optional.ofNullable(coverageConfiguration.getIgnoredFiles()).orElse(Collections.emptySet()));
        return coverageManager;
    }

    private Optional<CoverageManager> getCoverageManager() {
        return Optional.ofNullable(this.coverageManager);
    }

    private void waitForDebuggerClient() {
        DebuggerConfiguration debuggerConfiguration = this.runConfig.getDebuggerConfiguration();
        if (debuggerConfiguration == null || debuggerConfiguration.getDebuggerPort() == 0) {
            return;
        }
        MuleDxMunitLock lock = new MuleDxMunitLock(debuggerConfiguration.getLockKey());
        lock.lock();
    }

    public ContainerSuiteRunDispatcher addSuiteRunDispatcherLister(SuiteRunDispatcherListener suiteRunDispatcherListener) {
        this.suiteRunDispatcherListeners.add(suiteRunDispatcherListener);
        return this;
    }

    private void sendCoverageReport(CoverageManager coverageManager, RemoteRunEventListener listener) {
        Optional<ApplicationCoverageReport> coverageReport = coverageManager.generateCoverageReport();
        if (coverageReport.isPresent()) {
            String coverageReportJson = new Gson().toJson(coverageReport.get());
            listener.notifyCoverageReport(coverageReportJson);
        }
    }

    private Long getSuiteTimeout() {
        return Long.valueOf(System.getProperty(MUNIT_SUITE_TIMEOUT_PROPERTY, DEFAULT_TIMEOUT.toString()));
    }

    private class SkipAfterFailureException
    extends Exception {
        private SkipAfterFailureException() {
        }
    }
}

