/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.wagon;

import java.io.File;
import java.util.Properties;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.shared.http.BasicAuthScope;
import org.apache.maven.wagon.shared.http.HttpConfiguration;
import org.apache.maven.wagon.shared.http.HttpMethodConfiguration;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.transport.wagon.WagonConfigurator;

public class SimplePlexusWagonConfigurator
implements WagonConfigurator {
    private static ExpressionEvaluator NO_OP_EXPRESSION_EVALUATOR = new ExpressionEvaluator(){

        @Override
        public Object evaluate(String s2) throws ExpressionEvaluationException {
            return s2;
        }

        @Override
        public File alignToBaseDirectory(File file) {
            return file;
        }
    };

    @Override
    public void configure(Wagon wagon, Object configuration) throws Exception {
        PlexusConfiguration config;
        if (configuration instanceof PlexusConfiguration) {
            config = (PlexusConfiguration)configuration;
        } else {
            if (!(configuration instanceof Xpp3Dom)) {
                if (configuration == null) {
                    return;
                }
                throw new IllegalArgumentException("Unexpected configuration type: " + configuration.getClass().getName());
            }
            config = new XmlPlexusConfiguration((Xpp3Dom)configuration);
        }
        PropertiesConverter propertiesConverter = new PropertiesConverter();
        if (wagon instanceof HttpWagon) {
            HttpWagon httpWagon = (HttpWagon)wagon;
            for (PlexusConfiguration plexusConfiguration : config.getChildren()) {
                PlexusConfiguration realmPlexusConfiguration;
                PlexusConfiguration portPlexusConfiguration;
                if ("httpHeaders".equals(plexusConfiguration.getName())) {
                    httpWagon.setHttpHeaders(SimplePlexusWagonConfigurator.convert(plexusConfiguration, Properties.class, propertiesConverter));
                }
                if ("timeout".equals(plexusConfiguration.getName())) {
                    httpWagon.setTimeout(Integer.valueOf(plexusConfiguration.getValue()));
                }
                if ("httpConfiguration".equals(plexusConfiguration.getName())) {
                    this.httpConfiguration(httpWagon, plexusConfiguration, propertiesConverter);
                }
                if (!"basicAuthScope".equals(plexusConfiguration.getName())) continue;
                BasicAuthScope basicAuthScope = new BasicAuthScope();
                PlexusConfiguration hostPlexusConfiguration = plexusConfiguration.getChild("host", false);
                if (hostPlexusConfiguration != null) {
                    basicAuthScope.setHost(hostPlexusConfiguration.getValue());
                }
                if ((portPlexusConfiguration = plexusConfiguration.getChild("port", false)) != null) {
                    basicAuthScope.setPort(portPlexusConfiguration.getValue());
                }
                if ((realmPlexusConfiguration = plexusConfiguration.getChild("realm", false)) != null) {
                    basicAuthScope.setRealm(realmPlexusConfiguration.getValue());
                }
                httpWagon.setBasicAuthScope(basicAuthScope);
            }
        }
    }

    private void httpConfiguration(HttpWagon httpWagon, PlexusConfiguration plexusConfiguration, PropertiesConverter propertiesConverter) throws ComponentConfigurationException {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        block12: for (PlexusConfiguration methodPlexusConfiguration : plexusConfiguration.getChildren()) {
            switch (methodPlexusConfiguration.getName()) {
                case "all": {
                    httpConfiguration.setAll(this.httpMethodConfiguration(plexusConfiguration.getChild("all"), propertiesConverter));
                    continue block12;
                }
                case "get": {
                    httpConfiguration.setGet(this.httpMethodConfiguration(plexusConfiguration.getChild("get"), propertiesConverter));
                    continue block12;
                }
                case "head": {
                    httpConfiguration.setHead(this.httpMethodConfiguration(plexusConfiguration.getChild("head"), propertiesConverter));
                    continue block12;
                }
                case "put": {
                    httpConfiguration.setPut(this.httpMethodConfiguration(plexusConfiguration.getChild("put"), propertiesConverter));
                    continue block12;
                }
            }
        }
        httpWagon.setHttpConfiguration(httpConfiguration);
    }

    private HttpMethodConfiguration httpMethodConfiguration(PlexusConfiguration plexusConfiguration, PropertiesConverter propertiesConverter) throws ComponentConfigurationException {
        PlexusConfiguration headers;
        PlexusConfiguration params;
        PlexusConfiguration readTimeout;
        HttpMethodConfiguration config = new HttpMethodConfiguration();
        config.setUsePreemptive(Boolean.valueOf(plexusConfiguration.getChild("usePreemptive").getValue()));
        config.setUseDefaultHeaders(Boolean.valueOf(plexusConfiguration.getChild("useDefaultHeaders").getValue()));
        PlexusConfiguration connectionTimeout = plexusConfiguration.getChild("connectionTimeout", false);
        if (connectionTimeout != null) {
            config.setConnectionTimeout(Integer.valueOf(connectionTimeout.getValue()));
        }
        if ((readTimeout = plexusConfiguration.getChild("readTimeout", false)) != null) {
            config.setReadTimeout(Integer.valueOf(readTimeout.getValue()));
        }
        if ((params = plexusConfiguration.getChild("params", false)) != null) {
            config.setParams(SimplePlexusWagonConfigurator.convert(params, Properties.class, propertiesConverter));
        }
        if ((headers = plexusConfiguration.getChild("headers", false)) != null) {
            config.setHeaders(SimplePlexusWagonConfigurator.convert(headers, Properties.class, propertiesConverter));
        }
        return config;
    }

    private static <T> T convert(PlexusConfiguration plexusConfiguration, Class<T> clazz, ConfigurationConverter configurationConverter) throws ComponentConfigurationException {
        return (T)configurationConverter.fromConfiguration(null, plexusConfiguration, clazz, null, SimplePlexusWagonConfigurator.class.getClassLoader(), NO_OP_EXPRESSION_EVALUATOR);
    }
}

