/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.plexus.classworlds.ClassWorldListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;

public final class RealmManager
implements ClassWorldListener {
    private static final boolean GET_IMPORT_REALMS_SUPPORTED;
    private final ConcurrentMap<ClassRealm, Set<String>> visibility = new ConcurrentHashMap<ClassRealm, Set<String>>(16, 0.75f, 1);
    private final ConcurrentMap<ClassRealm, Injector> injectors = new ConcurrentHashMap<ClassRealm, Injector>(16, 0.75f, 1);
    private final MutableBeanLocator beanLocator;

    public RealmManager(MutableBeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public static ClassRealm contextRealm() {
        for (ClassLoader tccl = Thread.currentThread().getContextClassLoader(); tccl != null; tccl = tccl.getParent()) {
            if (!(tccl instanceof ClassRealm)) continue;
            return (ClassRealm)tccl;
        }
        return null;
    }

    public Set<String> visibleRealmNames(ClassRealm contextRealm) {
        if (GET_IMPORT_REALMS_SUPPORTED && null != contextRealm) {
            Set<String> names = (Set<String>)this.visibility.get(contextRealm);
            if (null == names) {
                names = RealmManager.computeVisibleNames(contextRealm);
                this.visibility.putIfAbsent(contextRealm, names);
            }
            return names;
        }
        return null;
    }

    public boolean isManaged(ClassRealm realm) {
        return this.injectors.containsKey(realm);
    }

    public void manage(ClassRealm realm, Injector injector) {
        this.injectors.putIfAbsent(realm, injector);
    }

    @Override
    public void realmCreated(ClassRealm realm) {
    }

    @Override
    public void realmDisposed(ClassRealm realm) {
        this.visibility.remove(realm);
        Injector injector = (Injector)this.injectors.remove(realm);
        if (null != injector) {
            this.beanLocator.remove(new InjectorBindings(injector, null));
        }
    }

    private static Set<String> computeVisibleNames(ClassRealm forRealm) {
        HashSet<String> visibleRealmNames = new HashSet<String>();
        ArrayList<ClassRealm> searchRealms = new ArrayList<ClassRealm>();
        searchRealms.add(forRealm);
        for (int i = 0; i < searchRealms.size(); ++i) {
            ClassRealm realm = (ClassRealm)searchRealms.get(i);
            if (!visibleRealmNames.add(realm.toString())) continue;
            searchRealms.addAll(realm.getImportRealms());
            ClassRealm parent = realm.getParentRealm();
            if (null == parent) continue;
            searchRealms.add(parent);
        }
        return visibleRealmNames;
    }

    static {
        boolean getImportRealmsSupported = true;
        try {
            ClassRealm.class.getDeclaredMethod("getImportRealms", new Class[0]);
        }
        catch (Exception e) {
            getImportRealmsSupported = false;
        }
        catch (LinkageError e) {
            getImportRealmsSupported = false;
        }
        GET_IMPORT_REALMS_SUPPORTED = getImportRealmsSupported;
    }
}

