/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.render.WidthUtilities;

public class WidthLongestWordMinCol
implements V2_Width {
    protected int min;
    protected int[] minAr;

    public WidthLongestWordMinCol(int min2) {
        if (min2 < 3) {
            throw new IllegalArgumentException("minimum column width cannot be smaller than 3");
        }
        this.min = min2;
    }

    public WidthLongestWordMinCol(int[] minAr) {
        if (minAr == null) {
            throw new IllegalArgumentException("minimum array cannot be null");
        }
        for (int m4 : minAr) {
            if (m4 == -1 || m4 >= 3) continue;
            throw new IllegalArgumentException("array contains minimum column width smaller than 3");
        }
        this.minAr = minAr;
    }

    @Override
    public int[] getColumnWidths(V2_AsciiTable table) {
        if (table == null) {
            return null;
        }
        if (this.minAr != null && this.minAr.length != table.getColumnCount()) {
            throw new IllegalArgumentException("minAr length is not the same as rows in the table");
        }
        int[] ret = WidthUtilities.longestWord(table);
        for (int i = 0; i < ret.length; ++i) {
            if (this.min != 0) {
                if (ret[i] >= this.min) continue;
                ret[i] = this.min;
                continue;
            }
            if (this.minAr == null || this.minAr[i] == -1 || ret[i] >= this.minAr[i]) continue;
            ret[i] = this.minAr[i];
        }
        return ret;
    }
}

