/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.v2.RenderedTable;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.BorderPosition;
import de.vandermeer.asciitable.v2.render.BorderType;
import de.vandermeer.asciitable.v2.render.ProcessedRow;
import de.vandermeer.asciitable.v2.render.RenderUtilities;
import de.vandermeer.asciitable.v2.render.V2_TableRenderer;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.RuleRow;
import de.vandermeer.asciitable.v2.row.RuleRowType;
import de.vandermeer.asciitable.v2.row.V2_Row;
import de.vandermeer.asciitable.v2.themes.ThemeValidator;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import de.vandermeer.asciitable.v2.themes.V2_RowTheme;
import de.vandermeer.asciitable.v2.themes.V2_TableTheme;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class V2_AsciiTableRenderer
implements V2_TableRenderer {
    char paddingChar = (char)32;
    V2_TableTheme theme = V2_E_TableThemes.PLAIN_7BIT.get();
    V2_Width width = null;
    List<ProcessedRow> rows = new LinkedList<ProcessedRow>();

    @Override
    public V2_AsciiTableRenderer setWidth(V2_Width width) {
        if (width != null) {
            this.width = width;
        }
        return this;
    }

    @Override
    public RenderedTable render(V2_AsciiTable table) {
        this.rows.clear();
        if (table == null || table.getColumnCount() == 0) {
            throw new IllegalArgumentException("wrong table argument: table is null or has no columns");
        }
        if (this.width == null) {
            throw new IllegalArgumentException("wrong table width argument: no width set");
        }
        int[] cols = this.width.getColumnWidths(table);
        for (V2_Row row : table.getTable()) {
            ProcessedRow pr = new ProcessedRow(row, cols, table.getColumnCount());
            if (row instanceof ContentRow) {
                ContentRow crow = (ContentRow)row;
                String[][] procColumns = RenderUtilities.createContentArray(crow.getColumns(), cols, crow.getPadding());
                pr.setProcessedColumns(procColumns);
                pr.setBorderTypes(RenderUtilities.getBorderTypes_ContentRow(procColumns[0], crow, table.getColumnCount()));
            }
            this.rows.add(pr);
        }
        BorderType[] array = RenderUtilities.getBorderTypes_TopRule(this.rows.size() > 1 ? this.rows.get(1) : null, this.rows.get(0).getOriginalRow(), table.getColumnCount());
        this.rows.get(0).setBorderTypes(array);
        array = RenderUtilities.getBorderTypes_BottomRule(this.rows.size() > 1 ? this.rows.get(this.rows.size() - 2) : null, this.rows.get(this.rows.size() - 1).getOriginalRow(), table.getColumnCount());
        this.rows.get(this.rows.size() - 1).setBorderTypes(array);
        if (this.rows.size() > 2) {
            for (int r = 1; r < this.rows.size() - 1; ++r) {
                array = RenderUtilities.getBorderTypes_MidRule(this.rows.get(r - 1), r < this.rows.size() - 2 ? this.rows.get(r + 1) : null, this.rows.get(r).getOriginalRow(), table.getColumnCount());
                this.rows.get(r).setBorderTypes(array);
            }
        }
        LinkedList<StrBuilder> ret = new LinkedList<StrBuilder>();
        for (int i = 0; i < this.rows.size(); ++i) {
            V2_Row original = this.rows.get(i).getOriginalRow();
            if (original instanceof ContentRow) {
                ret.add(this.renderContentRow(this.rows.get(i), cols));
                continue;
            }
            if (original instanceof RuleRow) {
                if (i == 0) {
                    ret.add(this.renderRuleRow(this.rows.get(i), cols, RuleRowType.TOP));
                    continue;
                }
                if (i == this.rows.size() - 1) {
                    ret.add(this.renderRuleRow(this.rows.get(i), cols, RuleRowType.BOTTOM));
                    continue;
                }
                ret.add(this.renderRuleRow(this.rows.get(i), cols, null));
                continue;
            }
            System.err.println("ERROR in renderering");
        }
        return new RenderedTable(ret);
    }

    protected final StrBuilder renderContentRow(ProcessedRow row, int[] cols) {
        StrBuilder ret = new StrBuilder(100);
        V2_RowTheme rt = null;
        String[][] columns = row.getProcessedColumns();
        BorderType[] borders = row.getBorderTypes();
        char[] alignment = ((ContentRow)row.getOriginalRow()).getAlignment();
        int[] padding = ((ContentRow)row.getOriginalRow()).getPadding();
        for (int i = 0; i < columns.length; ++i) {
            rt = this.theme.getContent();
            if (i != 0) {
                ret.appendNewLine();
            }
            int span = 0;
            for (int k = 0; k < borders.length; ++k) {
                if (borders[k] != BorderType.NONE) {
                    if (k == 0) {
                        ret.append(RenderUtilities.getChar(BorderPosition.LEFT, borders[k], rt));
                    } else if (k == borders.length - 1) {
                        ret.append(RenderUtilities.getChar(BorderPosition.RIGHT, borders[k], rt));
                    } else {
                        ret.append(RenderUtilities.getChar(BorderPosition.MIDDLE, borders[k], rt));
                    }
                }
                if (k >= columns[i].length) continue;
                if (ArrayUtils.contains(columns[i], null)) {
                    int s2;
                    int width;
                    if (columns[i][k] == null) {
                        if (k == columns[i].length - 1) {
                            width = 0;
                            for (s2 = 0; s2 < span; ++s2) {
                                width += cols[s2];
                            }
                            width += span;
                            ret.appendFixedWidthPadRight("", width += cols[k], this.paddingChar);
                            continue;
                        }
                        ++span;
                        continue;
                    }
                    if ("".equals(columns[i][k])) {
                        for (int s3 = 0; s3 < span; ++s3) {
                            ret.appendFixedWidthPadRight("", cols[s3], this.paddingChar);
                        }
                        ret.appendFixedWidthPadRight("", span, this.paddingChar);
                        span = 0;
                        ret.appendFixedWidthPadRight(columns[i][k], cols[k], this.paddingChar);
                        continue;
                    }
                    width = 0;
                    for (s2 = 0; s2 < span; ++s2) {
                        width += cols[s2];
                    }
                    width += span;
                    this.appendWithAlignment(alignment[k], ret, columns[i][k], width += cols[k], this.paddingChar, padding[k], i == columns.length);
                    span = 0;
                    continue;
                }
                this.appendWithAlignment(alignment[k], ret, columns[i][k], cols[k], this.paddingChar, padding[k], i == columns.length - 1);
            }
        }
        return ret;
    }

    private void appendWithAlignment(char alignment, StrBuilder sb, String str, int width, char paddingChar, int padding, boolean isLastLine) {
        int i;
        if (padding > 0) {
            width -= padding * 2;
        }
        for (i = 0; i < padding; ++i) {
            sb.append(paddingChar);
        }
        if ('l' == alignment) {
            sb.appendFixedWidthPadRight(str, width, paddingChar);
        } else if ('r' == alignment) {
            sb.appendFixedWidthPadLeft(str, width, paddingChar);
        } else if ('c' == alignment) {
            sb.append(StringUtils.center(str, width, paddingChar));
        } else if ('j' == alignment || 't' == alignment) {
            if (isLastLine) {
                if ('j' == alignment) {
                    sb.appendFixedWidthPadRight(str, width, paddingChar);
                } else {
                    sb.appendFixedWidthPadLeft(str, width, paddingChar);
                }
            } else {
                String[] ar = StringUtils.split(str);
                int length = 0;
                for (String s2 : ar) {
                    length += s2.length();
                }
                int first = (width - length) / (ar.length - 1) * (ar.length - 1);
                for (int i2 = 0; i2 < ar.length - 1; ++i2) {
                    if (first == 0) continue;
                    int n = i2;
                    ar[n] = ar[n] + " ";
                    --first;
                }
                int second = (width - length) % (ar.length - 1);
                for (int i3 = 0; i3 < ar.length - 1; ++i3) {
                    if (second == 0) continue;
                    int n = i3;
                    ar[n] = ar[n] + " ";
                    --second;
                }
                sb.append(StringUtils.join(ar));
            }
        } else {
            System.err.println("ERROR RENDER ALIGNMENT");
        }
        for (i = 0; i < padding; ++i) {
            sb.append(paddingChar);
        }
    }

    protected final StrBuilder renderRuleRow(ProcessedRow row, int[] cols, RuleRowType assumeType) {
        StrBuilder ret = new StrBuilder(100);
        V2_RowTheme rt = null;
        BorderType[] borders = row.getBorderTypes();
        RuleRow original = (RuleRow)row.getOriginalRow();
        RuleRowType type = assumeType == null ? original.getRuleType() : assumeType;
        block0 : switch (type) {
            case BOTTOM: {
                switch (original.getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getBottom();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getBottomStrong();
                    }
                }
                break;
            }
            case MID: {
                switch (original.getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getMid();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getMidStrong();
                    }
                }
                break;
            }
            case TOP: {
                switch (original.getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getTop();
                        break block0;
                    }
                    case STRONG: {
                        rt = this.theme.getTopStrong();
                    }
                }
            }
        }
        for (int k = 0; k < borders.length; ++k) {
            if (k == 0) {
                ret.append(RenderUtilities.getChar(BorderPosition.LEFT, borders[k], rt));
            } else if (k == borders.length - 1) {
                ret.append(RenderUtilities.getChar(BorderPosition.RIGHT, borders[k], rt));
            } else {
                ret.append(RenderUtilities.getChar(BorderPosition.MIDDLE, borders[k], rt));
            }
            if (k >= cols.length) continue;
            ret.appendPadding(cols[k], rt.getMid());
        }
        return ret;
    }

    @Override
    public V2_AsciiTableRenderer setPaddingChar(char pChar) {
        this.paddingChar = pChar;
        return this;
    }

    @Override
    public V2_AsciiTableRenderer setTheme(V2_TableTheme theme) {
        if (theme != null) {
            ThemeValidator.validateTableTheme(theme);
            this.theme = theme;
        }
        return this;
    }
}

