/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.nio.ByteBuffer;
import org.glassfish.jersey.jdk.connector.internal.ParseException;

class HttpParserUtils {
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte SP = 32;
    static final byte HT = 9;
    static final byte COMMA = 44;
    static final byte COLON = 58;
    static final byte SEMI_COLON = 59;
    static final byte A = 65;
    static final byte Z = 90;
    static final byte a = 97;
    static final byte LC_OFFSET = -32;

    HttpParserUtils() {
    }

    static int skipSpaces(ByteBuffer input, int offset, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte b = input.get(offset);
            if (HttpParserUtils.isNotSpaceAndTab(b)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    static boolean isNotSpaceAndTab(byte b) {
        return !HttpParserUtils.isSpaceOrTab(b);
    }

    static boolean isSpaceOrTab(byte b) {
        return b == 32 || b == 9;
    }

    static class ContentParsingState {
        boolean isLastChunk;
        int chunkContentStart = -1;
        long chunkLength = -1L;
        long chunkRemainder = -1L;

        ContentParsingState() {
        }
    }

    static class HeaderParsingState {
        final int maxHeaderSize;
        int packetLimit;
        int state;
        int subState;
        int start;
        int offset;
        int checkpoint = -1;
        int checkpoint2 = -1;
        String headerName;
        long parsingNumericValue;
        int contentLengthHeadersCount;
        boolean contentLengthsDiffer;

        HeaderParsingState(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
        }

        void recycle() {
            this.state = 0;
            this.subState = 0;
            this.start = 0;
            this.offset = 0;
            this.checkpoint = -1;
            this.checkpoint2 = -1;
            this.parsingNumericValue = 0L;
            this.contentLengthHeadersCount = 0;
            this.contentLengthsDiffer = false;
            this.headerName = null;
            this.packetLimit = this.maxHeaderSize;
        }

        void checkOverflow(String errorDescriptionIfOverflow) throws ParseException {
            if (this.offset < this.packetLimit) {
                return;
            }
            throw new ParseException(errorDescriptionIfOverflow);
        }
    }
}

