/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.net.SocketAddress;
import org.glassfish.jersey.jdk.connector.internal.CompletionHandler;

class Filter<UP_IN, UP_OUT, DOWN_OUT, DOWN_IN> {
    protected volatile Filter<?, ?, UP_IN, UP_OUT> upstreamFilter = null;
    protected final Filter<DOWN_OUT, DOWN_IN, ?, ?> downstreamFilter;

    Filter(Filter<DOWN_OUT, DOWN_IN, ?, ?> downstreamFilter) {
        this.downstreamFilter = downstreamFilter;
    }

    void write(UP_IN data, CompletionHandler<UP_IN> completionHandler) {
    }

    void close() {
        if (this.downstreamFilter != null) {
            this.downstreamFilter.close();
        }
    }

    void startSsl() {
        if (this.downstreamFilter != null) {
            this.downstreamFilter.startSsl();
        }
    }

    void connect(SocketAddress address, Filter<?, ?, UP_IN, UP_OUT> upstreamFilter) {
        this.upstreamFilter = upstreamFilter;
        this.handleConnect(address, upstreamFilter);
        if (this.downstreamFilter != null) {
            this.downstreamFilter.connect(address, this);
        }
    }

    void onConnect() {
        this.processConnect();
        if (this.upstreamFilter != null) {
            this.upstreamFilter.onConnect();
        }
    }

    final void onRead(DOWN_IN data) {
        if (this.processRead(data) && this.upstreamFilter != null) {
            DOWN_IN _data;
            try {
                _data = data;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot pass message of different type from filter input to filter output");
            }
            this.upstreamFilter.onRead(_data);
        }
    }

    final void onConnectionClosed() {
        this.processConnectionClosed();
        if (this.upstreamFilter != null) {
            this.upstreamFilter.onConnectionClosed();
        }
    }

    final void onSslHandshakeCompleted() {
        this.processSslHandshakeCompleted();
        if (this.upstreamFilter != null) {
            this.upstreamFilter.onSslHandshakeCompleted();
        }
    }

    final void onError(Throwable t) {
        this.processError(t);
        if (this.upstreamFilter != null) {
            this.upstreamFilter.onError(t);
        }
    }

    void handleConnect(SocketAddress address, Filter upstreamFilter) {
    }

    void processConnect() {
    }

    boolean processRead(DOWN_IN data) {
        return true;
    }

    void processConnectionClosed() {
    }

    void processSslHandshakeCompleted() {
    }

    void processError(Throwable t) {
    }
}

