/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.project;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.munit.remote.runtime.utils.MuleVersion;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.archiver.MuleArchiver;
import org.mule.tools.api.packager.archiver.MuleExplodedArchiver;
import org.mule.tools.api.packager.builder.MulePackageBuilder;
import org.mule.tools.api.packager.packaging.PackagingOptions;
import org.mule.tools.api.packager.sources.DefaultValuesMuleArtifactJsonGenerator;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.ProjectStructure;
import org.mule.tools.api.util.MavenComponents;
import org.mule.tools.api.util.SourcesProcessor;

public class MuleApplicationStructureGenerator
implements ApplicationStructureGenerator {
    public static final String RUN_CONFIGURATION_JSON = "run-configuration.json";
    public static final Path RUN_CONFIGURATION_PATH = Paths.get(FolderNames.META_INF.value(), org.mule.tools.api.packager.structure.FolderNames.MUNIT.value(), "run-configuration.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final MuleVersion LOCAL_REPOSITORY_MIN_MULE_VERSION = new MuleVersion("4.2.2");
    protected Path baseFolderPath;
    protected Path originFolderPath;
    protected MulePackageBuilder packageBuilder;
    protected Pom pom;
    protected List<BundleDependency> dependencies = Collections.emptyList();
    protected MavenComponents mavenComponents;
    protected boolean heavyWeight;

    public MuleApplicationStructureGenerator(Path baseFolderPath, Path sourceFolder) {
        Preconditions.checkArgument((baseFolderPath != null ? 1 : 0) != 0, (String)"The base folder must not be null");
        Preconditions.checkArgument((sourceFolder != null ? 1 : 0) != 0, (String)"The source folder must not be null");
        this.baseFolderPath = baseFolderPath;
        this.originFolderPath = sourceFolder;
    }

    public MuleApplicationStructureGenerator withMavenComponents(MavenComponents mavenComponents) {
        Preconditions.checkArgument((mavenComponents != null ? 1 : 0) != 0, (String)"The maven components must not be null");
        this.mavenComponents = mavenComponents;
        return this;
    }

    public MuleApplicationStructureGenerator isHeavyWeight(boolean heavyWeight) {
        this.heavyWeight = heavyWeight;
        return this;
    }

    public MuleApplicationStructureGenerator withPackageBuilder(MulePackageBuilder packageBuilder) {
        Preconditions.checkArgument((packageBuilder != null ? 1 : 0) != 0, (String)"The package builder must not be null");
        this.packageBuilder = packageBuilder;
        return this;
    }

    public MuleApplicationStructureGenerator withDependencies(List<BundleDependency> dependencies) {
        Preconditions.checkArgument((dependencies != null ? 1 : 0) != 0, (String)"The dependencies must not be null");
        this.dependencies = dependencies;
        return this;
    }

    public MuleApplicationStructureGenerator withPom(Pom pom) {
        Preconditions.checkArgument((pom != null ? 1 : 0) != 0, (String)"The pom must not be null");
        this.pom = pom;
        return this;
    }

    @Override
    public Path generate(Path destinationFolder, RunConfiguration runConfiguration) throws Exception {
        Preconditions.checkArgument((destinationFolder != null ? 1 : 0) != 0, (String)"The destination folder must not be null");
        PackagingOptions packagingOptions = this.buildPackagingOptions(runConfiguration);
        this.createExplodedPackage(destinationFolder, runConfiguration, packagingOptions);
        this.reGenerateMuleArtifactJson(destinationFolder, packagingOptions);
        return destinationFolder;
    }

    private PackagingOptions buildPackagingOptions(RunConfiguration runConfiguration) {
        MuleVersion runtimeVersion = new MuleVersion(runConfiguration.getContainerConfiguration().getRuntimeId());
        boolean isLightweight = !this.heavyWeight;
        boolean useLocalRepository = !this.heavyWeight && runtimeVersion.atLeast(LOCAL_REPOSITORY_MIN_MULE_VERSION);
        return new PackagingOptions(false, isLightweight, false, true, useLocalRepository);
    }

    private void createExplodedPackage(Path destinationFolderPath, RunConfiguration runConfiguration, PackagingOptions packagingOptions) throws Exception {
        MuleExplodedArchiver archiver = new MuleExplodedArchiver();
        archiver.getArchiver().setDuplicateBehavior("add");
        Path workingDir = destinationFolderPath.getParent();
        Path repositoryLocation = workingDir.resolve(org.mule.tools.api.packager.structure.FolderNames.REPOSITORY.value());
        FileUtils.copyDirectoryToDirectory((File)this.originFolderPath.resolve(org.mule.tools.api.packager.structure.FolderNames.META_INF.value()).toFile(), (File)workingDir.toFile());
        if (this.mavenComponents != null) {
            SourcesProcessor processSources = new SourcesProcessor(this.mavenComponents);
            processSources.process(true, packagingOptions.isLightweightPackage(), packagingOptions.isUseLocalRepository(), packagingOptions.isTestPackage(), workingDir.toFile(), workingDir.resolve(org.mule.tools.api.packager.structure.FolderNames.META_INF.value()).resolve(org.mule.tools.api.packager.structure.FolderNames.MULE_ARTIFACT.value()).toFile(), Optional.empty());
        }
        Path metaInfPath = workingDir.resolve(org.mule.tools.api.packager.structure.FolderNames.META_INF.value());
        this.packageBuilder.withPackagingOptions(packagingOptions).withArchiver((MuleArchiver)archiver).withClasses(this.originFolderPath.resolve(org.mule.tools.api.packager.structure.FolderNames.CLASSES.value()).toFile()).withMaven(metaInfPath.resolve(org.mule.tools.api.packager.structure.FolderNames.MAVEN.value()).toFile()).withMuleArtifact(metaInfPath.resolve(org.mule.tools.api.packager.structure.FolderNames.MULE_ARTIFACT.value()).toFile()).withTestClasses(this.originFolderPath.resolve(org.mule.tools.api.packager.structure.FolderNames.TEST_CLASSES.value()).toFile()).withTestMule(this.originFolderPath.resolve(org.mule.tools.api.packager.structure.FolderNames.TEST_MULE.value()).resolve(org.mule.tools.api.packager.structure.FolderNames.MUNIT.value()).toFile());
        if (!packagingOptions.isLightweightPackage()) {
            this.packageBuilder.withRepository(repositoryLocation.toFile());
        }
        if (packagingOptions.isAttachMuleSources()) {
            this.packageBuilder.withMuleSrc(metaInfPath.resolve(org.mule.tools.api.packager.structure.FolderNames.MULE_SRC.value()).toFile());
        }
        this.packageBuilder.createPackage(destinationFolderPath);
        File runConfigurationFile = destinationFolderPath.resolve(RUN_CONFIGURATION_PATH).toFile();
        FileUtils.writeStringToFile((File)runConfigurationFile, (String)gson.toJson((Object)runConfiguration), (Charset)Charset.defaultCharset());
    }

    protected void reGenerateMuleArtifactJson(Path destinationFolderPath, PackagingOptions packagingOptions) throws IOException {
        Path muleArtifactFolderPath = destinationFolderPath.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value());
        ProjectStructure projectStructure = new ProjectStructure(this.baseFolderPath, packagingOptions.isTestPackage());
        MuleArtifactContentResolver muleArtifactContentResolver = new MuleArtifactContentResolver(projectStructure, this.pom, this.dependencies);
        new DefaultValuesMuleArtifactJsonGenerator().generate(muleArtifactFolderPath, muleArtifactFolderPath, muleArtifactContentResolver);
    }
}

