/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.verification.fabric;

import com.google.gson.JsonArray;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.fabric.RuntimeFabricClient;
import org.mule.tools.client.fabric.model.DeploymentDetailedResponse;
import org.mule.tools.client.fabric.model.DeploymentGenericResponse;
import org.mule.tools.client.fabric.model.Deployments;
import org.mule.tools.deployment.fabric.RequestBuilder;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.RuntimeFabricDeployment;
import org.mule.tools.verification.DefaultDeploymentVerification;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.DeploymentVerificationStrategy;

public class RuntimeFabricDeploymentVerification
implements DeploymentVerification {
    private final RuntimeFabricClient client;
    private final DefaultDeploymentVerification verification;
    private static final String FAILED_STATUS = "FAILED";
    private static final String APPLIED_STATUS = "APPLIED";
    private static final String STARTED_STATUS = "STARTED";

    public RuntimeFabricDeploymentVerification(RuntimeFabricClient client) {
        this.client = client;
        this.verification = new DefaultDeploymentVerification(new RuntimeFabricDeploymentVerificationStrategy());
    }

    @Override
    public void assertDeployment(Deployment deployment) throws DeploymentException {
        this.verification.assertDeployment(deployment);
    }

    private class RuntimeFabricDeploymentVerificationStrategy
    implements DeploymentVerificationStrategy {
        private Deployments deployments;
        private String deploymentId;

        private RuntimeFabricDeploymentVerificationStrategy() {
            this.deployments = RuntimeFabricDeploymentVerification.this.client.getDeployments();
        }

        @Override
        public Predicate<Deployment> isDeployed() {
            return deployment -> {
                try {
                    String deploymentId = this.getDeploymentId((Deployment)deployment);
                    if (deploymentId == null) {
                        return false;
                    }
                    DeploymentDetailedResponse response = RuntimeFabricDeploymentVerification.this.client.getDeployment(deploymentId);
                    if (response != null) {
                        if (StringUtils.equals(response.status, RuntimeFabricDeploymentVerification.FAILED_STATUS)) {
                            throw new IllegalStateException("Deployment failed");
                        }
                        if (StringUtils.equals(response.status, RuntimeFabricDeploymentVerification.APPLIED_STATUS) || StringUtils.equals(response.status, RuntimeFabricDeploymentVerification.STARTED_STATUS)) {
                            return true;
                        }
                    }
                }
                catch (DeploymentException e) {
                    e.printStackTrace();
                    return false;
                }
                return false;
            };
        }

        private String getDeploymentId(Deployment deployment) throws DeploymentException {
            RuntimeFabricDeployment deploymentRTF = (RuntimeFabricDeployment)deployment;
            String targetName = deploymentRTF.getTarget();
            JsonArray targets = RuntimeFabricDeploymentVerification.this.client.getTargets();
            String targetID = null;
            if (targets != null) {
                targetID = RequestBuilder.getTargetId(targets, targetName);
            }
            if (this.deploymentId == null) {
                this.deployments = RuntimeFabricDeploymentVerification.this.client.getDeployments();
                for (DeploymentGenericResponse dep : this.deployments) {
                    if (!StringUtils.equals(dep.name, deploymentRTF.getApplicationName()) || targets != null && !StringUtils.equals(targetID, dep.target.targetId)) continue;
                    this.deploymentId = dep.id;
                    return this.deploymentId;
                }
            }
            return this.deploymentId;
        }

        @Override
        public Consumer<Deployment> onTimeout() {
            return deployment -> {
                try {
                    RuntimeFabricDeploymentVerification.this.client.getDeployment(this.getDeploymentId((Deployment)deployment));
                }
                catch (DeploymentException e) {
                    e.printStackTrace();
                }
            };
        }
    }
}

