/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation.standalone;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MuleCoreJarVersionFinder
implements FileVisitor<Path> {
    private final Pattern muleCoreJarFileNameRegex = Pattern.compile("mule-core-(\\d+\\.\\d+\\.\\d+.*)\\.jar");
    private String muleCoreVersion;

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return this.shouldContinueTraversing();
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String fileName = file.getFileName().toString();
        Matcher fileNameMatcher = this.muleCoreJarFileNameRegex.matcher(fileName);
        if (fileNameMatcher.matches()) {
            this.muleCoreVersion = fileNameMatcher.group(1);
        }
        return this.shouldContinueTraversing();
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return this.shouldContinueTraversing();
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return this.shouldContinueTraversing();
    }

    private FileVisitResult shouldContinueTraversing() {
        return StringUtils.isBlank(this.muleCoreVersion) ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    public String getMuleCoreVersion() {
        return this.muleCoreVersion;
    }
}

