/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.resolver.visitor;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.validation.resolver.model.ProjectDependencyNode;
import org.mule.tools.api.validation.resolver.visitor.DependencyNodeVisitor;
import org.mule.tools.api.validation.resolver.visitor.MuleDomainVisitor;
import org.mule.tools.api.validation.resolver.visitor.MulePluginVisitor;

public class MulePluginResolverVisitor
implements DependencyNodeVisitor {
    private final List<DependencyNodeVisitor> visitors;
    private static final List<DependencyNodeVisitor> DEFAULT_VISITORS = Lists.newArrayList(new MulePluginVisitor("compile"), new MuleDomainVisitor());

    public MulePluginResolverVisitor(List<DependencyNodeVisitor> visitors) {
        this.visitors = visitors;
    }

    public MulePluginResolverVisitor() {
        this.visitors = DEFAULT_VISITORS;
    }

    @Override
    public void visit(ProjectDependencyNode node) throws ValidationException {
        for (DependencyNodeVisitor visitor : this.visitors) {
            visitor.visit(node);
        }
    }

    @Override
    public Set<ArtifactCoordinates> getCollectedDependencies() {
        return this.visitors.stream().map(DependencyNodeVisitor::getCollectedDependencies).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

