/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.mule.tools.api.packager.DefaultProjectInformation;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.util.DependencyProject;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.util.ResolvedPom;
import org.mule.tools.api.validation.exchange.ExchangeRepositoryMetadata;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.AnypointDeployment;

public class MavenProjectInformation
implements ProjectInformation {
    private ProjectInformation projectInformation;
    private static final MavenProjectInformation mavenProjectInformation = new MavenProjectInformation();

    private MavenProjectInformation() {
    }

    public static MavenProjectInformation getProjectInformation(MavenSession session, MavenProject project, File projectBaseFolder, boolean testJar, List<Deployment> deployments, String classifier) {
        return MavenProjectInformation.getProjectInformation(session, project, projectBaseFolder, testJar, deployments, classifier, new ArrayList<String>());
    }

    public static MavenProjectInformation getProjectInformation(MavenSession session, MavenProject project, File projectBaseFolder, boolean testJar, List<Deployment> deployments, String classifier, List<String> customDomains) {
        DefaultProjectInformation.Builder builder = new DefaultProjectInformation.Builder();
        boolean isDeployment = MavenProjectInformation.isDeploymentGoal(session);
        builder.withGroupId(project.getGroupId()).withArtifactId(project.getArtifactId()).withVersion(project.getVersion()).withPackaging(project.getPackaging()).withClassifier(classifier).withProjectBaseFolder(Paths.get(projectBaseFolder.toURI())).withBuildDirectory(Paths.get(project.getBuild().getDirectory(), new String[0])).setTestProject(testJar).isDeployment(isDeployment).withResolvedPom(new ResolvedPom(project.getModel()));
        if (isDeployment) {
            Settings settings;
            DistributionManagement management = project.getDistributionManagement();
            DeploymentRepository repository = management != null ? management.getRepository() : null;
            Optional<ExchangeRepositoryMetadata> metadata = MavenProjectInformation.getExchangeRepositoryMetadata(repository, settings = session.getSettings(), customDomains);
            if (metadata.isPresent()) {
                if (deployments != null && MavenProjectInformation.isPlatformDeployment(deployments)) {
                    builder.withDeployments(deployments);
                }
            } else {
                builder.withDeployments(deployments);
            }
        }
        builder.withDependencyProject(new DependencyProject(project));
        MavenProjectInformation.mavenProjectInformation.projectInformation = builder.build();
        return mavenProjectInformation;
    }

    private static boolean isDeploymentGoal(MavenSession session) {
        return session.getGoals().stream().anyMatch(goal -> StringUtils.containsIgnoreCase(goal, "deploy")) || session.getSystemProperties().getProperty("muleDeploy") != null;
    }

    private static boolean isPlatformDeployment(List<Deployment> deployments) {
        return deployments.stream().anyMatch(d -> d instanceof AnypointDeployment);
    }

    @Override
    public String getGroupId() {
        return this.projectInformation.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.projectInformation.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.projectInformation.getVersion();
    }

    @Override
    public String getClassifier() {
        return this.projectInformation.getClassifier();
    }

    @Override
    public String getPackaging() {
        return this.projectInformation.getPackaging();
    }

    @Override
    public Path getProjectBaseFolder() {
        return this.projectInformation.getProjectBaseFolder();
    }

    @Override
    public Path getBuildDirectory() {
        return this.projectInformation.getBuildDirectory();
    }

    @Override
    public boolean isTestProject() {
        return this.projectInformation.isTestProject();
    }

    @Override
    public Project getProject() {
        return this.projectInformation.getProject();
    }

    @Override
    public Optional<ExchangeRepositoryMetadata> getExchangeRepositoryMetadata() {
        return this.projectInformation.getExchangeRepositoryMetadata();
    }

    @Override
    public boolean isDeployment() {
        return this.projectInformation.isDeployment();
    }

    @Override
    public List<Deployment> getDeployments() {
        return this.projectInformation.getDeployments();
    }

    @Override
    public Pom getEffectivePom() {
        return this.projectInformation.getEffectivePom();
    }

    private static Optional<ExchangeRepositoryMetadata> getExchangeRepositoryMetadata(DeploymentRepository repository, Settings settings, List<String> customDomains) {
        Server server;
        ExchangeRepositoryMetadata metadata = null;
        ExchangeUriChecker exchangeUriChecker = new ExchangeUriChecker(customDomains);
        if (repository != null && exchangeUriChecker.isExchangeRepo(repository.getUrl()) && (server = settings.getServer(repository.getId())) != null) {
            Credentials credentials = new Credentials(server.getUsername(), server.getPassword());
            metadata = new ExchangeRepositoryMetadata(credentials, repository.getUrl(), customDomains);
        }
        return Optional.ofNullable(metadata);
    }
}

