/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class ArtifactCoordinates {
    public static final String DEFAULT_ARTIFACT_TYPE = "jar";
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String classifier;
    private String scope;

    protected ArtifactCoordinates() {
        this.setType(DEFAULT_ARTIFACT_TYPE);
    }

    public ArtifactCoordinates(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, DEFAULT_ARTIFACT_TYPE, null);
    }

    public ArtifactCoordinates(String groupId, String artifactId, String version, String type, String classifier) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        this.setType(type);
        this.setClassifier(classifier);
    }

    public ArtifactCoordinates(String groupId, String artifactId, String version, String type, String classifier, String scope) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        this.setType(type);
        this.setClassifier(classifier);
        this.setScope(scope);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        Preconditions.checkArgument(StringUtils.isNotBlank(groupId), "Group id cannot be null nor blank");
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        Preconditions.checkArgument(StringUtils.isNotBlank(artifactId), "Artifact id can not be null nor blank");
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Preconditions.checkArgument(StringUtils.isNotBlank(version), "Version can not be null nor blank");
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        Preconditions.checkArgument(StringUtils.isNotBlank(type), "Type can not be null nor blank");
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String toString() {
        return this.groupId + ':' + this.artifactId + ':' + this.version + ':' + this.type + (StringUtils.isNotBlank(this.classifier) ? ':' + this.classifier : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactCoordinates that = (ArtifactCoordinates)o;
        if (!this.getArtifactId().equals(that.getArtifactId())) {
            return false;
        }
        if (!this.getGroupId().equals(that.getGroupId())) {
            return false;
        }
        if (!StringUtils.equals(this.getClassifier(), that.getClassifier())) {
            return false;
        }
        return this.getVersion().equals(that.getVersion());
    }

    public int hashCode() {
        int result = this.getArtifactId().hashCode();
        result = 31 * result + this.getGroupId().hashCode();
        result = 31 * result + this.getVersion().hashCode();
        if (this.getClassifier() != null) {
            result = 31 * result + this.getClassifier().hashCode();
        }
        return result;
    }
}

