/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;

public class MavenContainerOptSeparateClassLoaderFactory
extends MavenContainerClassLoaderFactory {
    public MavenContainerOptSeparateClassLoaderFactory(MavenClient mavenClient) {
        super(mavenClient);
    }

    @Override
    public ClassLoader create(String version, Product product, ClassLoader parentClassLoader, URL containerBaseFolder) {
        try {
            List<BundleDependency> bundleDependencies = this.resolveDependencies(version, product);
            Map<Boolean, List<BundleDependency>> partitionedDependencies = bundleDependencies.stream().filter(this::shouldKeepXmlApis).filter(bundleDependency -> !bundleDependency.getDescriptor().getGroupId().equals("org.mule.services")).collect(Collectors.partitioningBy(bundleDependency -> this.isMuleContainerGroupId(bundleDependency.getDescriptor().getGroupId())));
            List<URL> muleUrls = partitionedDependencies.get(true).stream().map(this.dependencyToUrl()).collect(Collectors.toList());
            List<URL> optUrls = partitionedDependencies.get(false).stream().map(this.dependencyToUrl()).collect(Collectors.toList());
            File containerFolderFile = FileUtils.toFile(containerBaseFolder);
            muleUrls.add(new URL(new File(containerFolderFile, "conf").toURI().toString() + "/"));
            return new URLClassLoader(muleUrls.toArray(new URL[muleUrls.size()]), (ClassLoader)new URLClassLoader(optUrls.toArray(new URL[optUrls.size()]), parentClassLoader));
        }
        catch (BundleDependenciesResolutionException e) {
            throw new IllegalArgumentException("Could not find embedded container bom artifact", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isMuleContainerGroupId(String groupId) {
        return groupId.equals("org.mule.runtime") || groupId.equals("org.mule.sdk") || groupId.equals("org.mule.weave") || groupId.equals("org.mule.mvel") || groupId.equals("org.mule.commons") || groupId.equals("com.mulesoft.mule.runtime") || groupId.equals("com.mulesoft.mule.runtime.modules") || groupId.equals("com.mulesoft.anypoint");
    }
}

