/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.notification;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineMessageNotification
extends EnrichedServerNotification {
    private static final long serialVersionUID = 6065691696506216248L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineMessageNotification.class);
    public static final int PROCESS_START = 1801;
    public static final int PROCESS_END = 1802;
    public static final int PROCESS_COMPLETE = 1804;

    public PipelineMessageNotification(EnrichedNotificationInfo notificationInfo, String name, int action) {
        super(notificationInfo, action, notificationInfo.getComponent().getRootContainerLocation() != null ? notificationInfo.getComponent().getRootContainerLocation().getGlobalName() : null);
        this.resourceIdentifier = name;
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    @Override
    public String getEventName() {
        return "PipelineMessageNotification";
    }

    public Optional<Component> getFailingComponent() {
        if (this.getException() == null) {
            return Optional.empty();
        }
        try {
            return Optional.of((Component)this.getException().getClass().getMethod("getFailingComponent", new Class[0]).invoke((Object)this.getException(), new Object[0]));
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Error accessing failing component for: %s", this.getException()), e);
            }
            return Optional.empty();
        }
    }

    static {
        PipelineMessageNotification.registerAction("pipeline process start", 1801);
        PipelineMessageNotification.registerAction("pipeline request message processing end", 1802);
        PipelineMessageNotification.registerAction("pipeline process complete", 1804);
    }
}

