/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.exception;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.munit.remote.exception.DeploymentException;

public class DeploymentExceptionThrower {
    private static final String DEPLOYMENT_EXCEPTION_CANONICAL_NAME = "org.mule.runtime.deployment.model.api.DeploymentException";

    public static void throwIfMatches(RuntimeException e) throws DeploymentException, RuntimeException {
        Preconditions.checkNotNull("The exception must no be null", e);
        List<Throwable> deploymentExceptions = DeploymentExceptionThrower.findCauses(e);
        if (!deploymentExceptions.isEmpty()) {
            throw new DeploymentException(deploymentExceptions.get(0));
        }
        throw e;
    }

    private static List<Throwable> findCauses(Throwable e) {
        List<Throwable> causalChain = Throwables.getCausalChain(e);
        return causalChain.stream().filter(t2 -> DEPLOYMENT_EXCEPTION_CANONICAL_NAME.equals(t2.getClass().getCanonicalName())).collect(Collectors.toList());
    }
}

