/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.Configurator;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class Launcher {
    protected static final String CLASSWORLDS_CONF = "classworlds.conf";
    protected static final String UBERJAR_CONF_DIR = "WORLDS-INF/conf/";
    protected ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();
    protected String mainClassName;
    protected String mainRealmName;
    protected ClassWorld world;
    private int exitCode = 0;

    public void setSystemClassLoader(ClassLoader loader) {
        this.systemClassLoader = loader;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setAppMain(String mainClassName, String mainRealmName) {
        this.mainClassName = mainClassName;
        this.mainRealmName = mainRealmName;
    }

    public String getMainRealmName() {
        return this.mainRealmName;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setWorld(ClassWorld world) {
        this.world = world;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    public void configure(InputStream is) throws IOException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        Configurator configurator = new Configurator(this);
        configurator.configure(is);
    }

    public Class<?> getMainClass() throws ClassNotFoundException, NoSuchRealmException {
        return this.getMainRealm().loadClass(this.getMainClassName());
    }

    public ClassRealm getMainRealm() throws NoSuchRealmException {
        return this.getWorld().getRealm(this.getMainRealmName());
    }

    protected Method getEnhancedMainMethod() throws ClassNotFoundException, NoSuchMethodException, NoSuchRealmException {
        Class<?> cwClass = this.getMainRealm().loadClass(ClassWorld.class.getName());
        Method m4 = this.getMainClass().getMethod("main", String[].class, cwClass);
        int modifiers = m4.getModifiers();
        if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && (m4.getReturnType() == Integer.TYPE || m4.getReturnType() == Void.TYPE)) {
            return m4;
        }
        throw new NoSuchMethodException("public static void main(String[] args, ClassWorld world)");
    }

    protected Method getMainMethod() throws ClassNotFoundException, NoSuchMethodException, NoSuchRealmException {
        Method m4 = this.getMainClass().getMethod("main", String[].class);
        int modifiers = m4.getModifiers();
        if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && (m4.getReturnType() == Integer.TYPE || m4.getReturnType() == Void.TYPE)) {
            return m4;
        }
        throw new NoSuchMethodException("public static void main(String[] args) in " + this.getMainClass());
    }

    public void launch(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        try {
            this.launchEnhanced(args);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.launchStandard(args);
            return;
        }
    }

    protected void launchEnhanced(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        ClassRealm mainRealm = this.getMainRealm();
        Class<?> mainClass = this.getMainClass();
        Method mainMethod = this.getEnhancedMainMethod();
        ClassRealm cl = mainRealm;
        Thread.currentThread().setContextClassLoader(cl);
        Object ret = mainMethod.invoke(mainClass, args, this.getWorld());
        if (ret instanceof Integer) {
            this.exitCode = (Integer)ret;
        }
        Thread.currentThread().setContextClassLoader(this.systemClassLoader);
    }

    protected void launchStandard(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        ClassRealm mainRealm = this.getMainRealm();
        Class<?> mainClass = this.getMainClass();
        Method mainMethod = this.getMainMethod();
        Thread.currentThread().setContextClassLoader(mainRealm);
        Object ret = mainMethod.invoke(mainClass, new Object[]{args});
        if (ret instanceof Integer) {
            this.exitCode = (Integer)ret;
        }
        Thread.currentThread().setContextClassLoader(this.systemClassLoader);
    }

    public static void main(String[] args) {
        try {
            int exitCode = Launcher.mainWithExitCode(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    public static int mainWithExitCode(String[] args) throws Exception {
        String classworldsConf = System.getProperty(CLASSWORLDS_CONF);
        Launcher launcher = new Launcher();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        launcher.setSystemClassLoader(cl);
        InputStream is = classworldsConf != null ? Files.newInputStream(Paths.get(classworldsConf, new String[0]), new OpenOption[0]) : ("true".equals(System.getProperty("classworlds.bootstrapped")) ? cl.getResourceAsStream("WORLDS-INF/conf/classworlds.conf") : cl.getResourceAsStream(CLASSWORLDS_CONF));
        if (is == null) {
            throw new Exception("classworlds configuration not specified nor found in the classpath");
        }
        launcher.configure(is);
        is.close();
        try {
            launcher.launch(args);
        }
        catch (InvocationTargetException e) {
            ClassRealm realm = launcher.getWorld().getRealm(launcher.getMainRealmName());
            URL[] constituents = realm.getURLs();
            System.out.println("---------------------------------------------------");
            for (int i = 0; i < constituents.length; ++i) {
                System.out.println("constituent[" + i + "]: " + constituents[i]);
            }
            System.out.println("---------------------------------------------------");
            Throwable t2 = e.getTargetException();
            if (t2 instanceof Exception) {
                throw (Exception)t2;
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            throw e;
        }
        return launcher.getExitCode();
    }
}

