/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.EncodingSupported;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoURLResource;

public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection
implements EncodingSupported {
    private Charset charset = StandardCharsets.UTF_8;

    @Override
    public boolean isConcurrentAccessSupported() {
        return false;
    }

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The zip file has not been set.");
        }
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{f.toURI().toURL()}, null){

            @Override
            public URL getResource(String name) {
                return this.findResource(name);
            }
        };
        URL url = new URL("jar:" + f.toURI().toURL() + "!/");
        JarFile jarFile = new JarFile(f);
        ZipFile zipFile = new ZipFile(f, this.charset != null ? this.charset.name() : "UTF8");
        Enumeration en = zipFile.getEntriesInPhysicalOrder();
        return new ZipFileResourceIterator(en, url, jarFile, zipFile, urlClassLoader);
    }

    @Override
    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    private static class ZipFileResourceIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        private final Enumeration<ZipArchiveEntry> en;
        private final URL url;
        private final JarFile jarFile;
        private final ZipFile zipFile;
        private final URLClassLoader urlClassLoader;

        public ZipFileResourceIterator(Enumeration<ZipArchiveEntry> en, URL url, JarFile jarFile, ZipFile zipFile, URLClassLoader urlClassLoader) {
            this.en = en;
            this.url = url;
            this.jarFile = jarFile;
            this.zipFile = zipFile;
            this.urlClassLoader = urlClassLoader;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            ZipArchiveEntry entry = this.en.nextElement();
            return entry.isUnixSymlink() ? new ZipFileSymlinkResource(this.jarFile, entry) : new ZipFileResource(this.jarFile, entry);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            try {
                this.urlClassLoader.close();
            }
            finally {
                try {
                    this.zipFile.close();
                }
                finally {
                    this.jarFile.close();
                }
            }
        }

        private class ZipFileSymlinkResource
        extends ZipFileResource
        implements SymlinkDestinationSupplier {
            private final ZipArchiveEntry entry;

            private ZipFileSymlinkResource(JarFile jarFile, ZipArchiveEntry entry) {
                super(jarFile, entry);
                this.entry = entry;
            }

            @Override
            public String getSymlinkDestination() throws IOException {
                return ZipFileResourceIterator.this.zipFile.getUnixSymlink(this.entry);
            }

            @Override
            public boolean isSymbolicLink() {
                return true;
            }
        }

        private class ZipFileResource
        extends PlexusIoURLResource {
            private final JarFile jarFile;

            private ZipFileResource(JarFile jarFile, ZipArchiveEntry entry) {
                super(entry.getName(), entry.getTime() == -1L ? 0L : entry.getTime(), entry.isDirectory() ? -1L : entry.getSize(), !entry.isDirectory(), entry.isDirectory(), true);
                this.jarFile = jarFile;
            }

            @Override
            public InputStream getContents() throws IOException {
                return this.jarFile.getInputStream(this.jarFile.getEntry(this.getName()));
            }

            @Override
            public URL getURL() throws IOException {
                String spec = this.getName();
                if (spec.startsWith("/")) {
                    spec = "./" + spec;
                    return new URL(ZipFileResourceIterator.this.url, spec);
                }
                return ZipFileResourceIterator.this.urlClassLoader.getResource(spec);
            }
        }
    }
}

