/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AbstractAsciiList;
import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.AsciiList_Check;
import de.vandermeer.asciilist.CheckListItem;
import de.vandermeer.asciilist.styles.ListStyle;
import de.vandermeer.asciilist.styles.ListStyle_CheckNested;
import de.vandermeer.asciilist.styles.NestedCheckStyles;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class CheckList
extends AbstractAsciiList
implements AsciiList_Check {
    protected ListStyle_CheckNested style;

    public CheckList() {
        this(true);
    }

    public CheckList(boolean isContinued) {
        super(isContinued);
        this.style = NestedCheckStyles.ALL_SQUARE_BRACKET_BLANK_X;
    }

    public CheckList(CheckList list) {
        super(list);
        this.style = list.style;
    }

    @Override
    public AsciiList_Check addItem(String item) {
        if (!StringUtils.isBlank(item)) {
            this.items.add(new CheckListItem(item, false));
        }
        return this;
    }

    @Override
    public AsciiList_Check addItemChecked(String item) {
        if (!StringUtils.isBlank(item)) {
            this.items.add(new CheckListItem(item, true));
        }
        return this;
    }

    @Override
    public AsciiList_Check setPreLabel(String preLabel) {
        if (!StringUtils.isBlank(preLabel)) {
            this.preLabelStr = preLabel;
        }
        return this;
    }

    @Override
    public AsciiList_Check setPostLabel(String postLabel) {
        if (!StringUtils.isBlank(postLabel)) {
            this.postLabelStr = postLabel;
        }
        return this;
    }

    @Override
    public AsciiList_Check setPostIndent(int indent) {
        if (indent >= 0) {
            this.postLabelIndent = indent;
        }
        return this;
    }

    protected String calculateItemLabel(AsciiListItem item) {
        String label = this.style.getStyle(this.level).getLabelUnchecked();
        if (item instanceof CheckListItem && ((CheckListItem)item).isChecked()) {
            label = this.style.getStyle(this.level).getLabelChecked();
        }
        return label;
    }

    @Override
    public String renderItem(AsciiListItem item, int position) {
        return item.render(this.preLabelIndent, this.preLabelStr, this.calculateItemLabel(item), this.postLabelStr, this.postLabelIndent);
    }

    @Override
    public AsciiList_Check setListStyle(ListStyle style) {
        if (style instanceof ListStyle_CheckNested) {
            this.style = (ListStyle_CheckNested)style;
        }
        return this;
    }

    @Override
    public AsciiList copy() {
        return new CheckList(this);
    }

    @Override
    public int calculateMaxIndentation(AsciiListItem item, int position) {
        return this.preLabelIndent + this.preLabelStr.length() + this.calculateItemLabel(item).length() + this.postLabelStr.length() + this.postLabelIndent;
    }

    @Override
    public AsciiList_Check addAllItems(Collection<String> items) {
        if (items != null) {
            for (String s2 : items) {
                this.addItem(s2);
            }
        }
        return this;
    }
}

