/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.container;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.Container;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.exception.DeploymentExceptionThrower;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentService;

public class EmbeddedContainer
implements Container {
    private org.mule.runtime.module.embedded.api.EmbeddedContainer container;
    private RunConfiguration runConfiguration;

    public EmbeddedContainer(org.mule.runtime.module.embedded.api.EmbeddedContainer container, RunConfiguration runConfiguration) {
        this.container = container;
        this.runConfiguration = runConfiguration;
    }

    @Override
    public void deployDomain() throws DeploymentException {
        String domainLocation = this.runConfiguration.getDomainLocation();
        if (StringUtils.isNotBlank((CharSequence)domainLocation)) {
            Path artifactLocation = Paths.get(domainLocation, new String[0]);
            ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, this.buildDeploymentConfiguration(true));
            DeploymentService deploymentService = this.container.getDeploymentService();
            try {
                deploymentService.deployDomain(artifactConfiguration);
            }
            catch (RuntimeException e) {
                DeploymentExceptionThrower.throwIfMatches(e);
            }
        }
    }

    @Override
    public void deployApplication(boolean enableXmlValidations, Map<String, Object> properties) throws DeploymentException {
        String applicationName = this.runConfiguration.getProjectName();
        String munitWorkingDirectoryPath = this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath();
        Path artifactLocation = Paths.get(munitWorkingDirectoryPath, applicationName);
        ArtifactConfiguration artifactConfiguration = this.getArtifactConfiguration(artifactLocation, this.buildDeploymentConfiguration(enableXmlValidations));
        DeploymentService deploymentService = this.container.getDeploymentService();
        MUnitUserPropertiesManager.addUserPropertiesToSystem(properties);
        try {
            deploymentService.deployApplication(artifactConfiguration);
        }
        catch (RuntimeException e) {
            DeploymentExceptionThrower.throwIfMatches(e);
        }
    }

    @Override
    public void undeployApplication(Map<String, Object> systemProperties) {
        if (this.runConfiguration.getClearParameters().booleanValue()) {
            MUnitUserPropertiesManager.removeProperties(systemProperties);
        }
        this.container.getDeploymentService().undeployApplication(this.runConfiguration.getProjectName());
    }

    private ArtifactConfiguration getArtifactConfiguration(Path artifactLocation, DeploymentConfiguration deploymentConfiguration) {
        return ArtifactConfiguration.builder().deploymentConfiguration(deploymentConfiguration).artifactLocation(artifactLocation.toFile()).build();
    }

    protected DeploymentConfiguration buildDeploymentConfiguration(boolean enableXmlValidations) {
        return DeploymentConfiguration.builder().lazyConnectionsEnabled(Container.enableLazyConnections().booleanValue()).lazyInitialization(Container.enableLazyInitialization().booleanValue()).xmlValidations(enableXmlValidations).build();
    }

    @Override
    public void start() {
        this.container.start();
    }

    @Override
    public void stop() {
        this.container.stop();
    }
}

