/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.tool.spy;

import java.util.Optional;

import org.mule.runtime.extension.api.runtime.operation.Result;

/**
 * Model that represents the result of a spy run
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class SpyResult {

  private Result result;
  private Throwable throwable;

  public Result getResult() {
    return result;
  }

  public Optional<Throwable> getThrowable() {
    return Optional.ofNullable(throwable);
  }

  public void setResult(Result result) {
    this.result = result;
  }

  public void setThrowable(Throwable throwable) {
    this.throwable = throwable;
  }
}

