/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.tool.spy;

import org.mule.munit.common.exception.MunitError;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedResult;

/**
 * Simple implementation of SpyProcess, who knows to process each of the contained processors.
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class SpyProcessImpl implements SpyProcess {

  private final Chain processors;

  public SpyProcessImpl(Chain processors) {
    this.processors = processors;
  }

  @Override
  public SpyResult spy(CoreEvent event) {
    final SpyResult spyResult = new SpyResult();
    Latch latch = new Latch();
    processors.process(EventedResult.from(event), result -> {
      spyResult.setResult(result);
      latch.release();
    }, (error, result) -> {
      spyResult.setThrowable(error);
      spyResult.setResult(result);
      latch.release();
    });
    try {
      latch.await();
    } catch (InterruptedException e) {
      throw new MunitError(e);
    }
    return spyResult;
  }

}

