/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.behavior;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.EventError;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.Property;
import org.mule.munit.common.model.Variable;
import org.mule.munit.mock.behavior.Behavior;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.privileged.event.MuleSession;

public class CallBehaviour
extends Behavior {
    private Flow flow;

    public CallBehaviour(ProcessorCall processorCall, Flow flow) {
        super(processorCall);
        this.flow = flow;
    }

    public void evaluate(MuleSession session, Event input) {
        if (!this.getEvent().isPresent()) {
            try {
                Event output = (Event)this.flow.execute(input).get();
                this.setEvent(this.buildEvent(session, output));
            }
            catch (ComponentExecutionException cause) {
                this.setEvent(this.buildEvent(session, cause.getEvent()));
            }
            catch (Throwable cause) {
                if (cause.getCause() instanceof ComponentExecutionException) {
                    this.setEvent(this.buildEvent(session, ((ComponentExecutionException)cause.getCause()).getEvent()));
                }
                throw new MunitError(String.format("There was a problem while evaluating '%s'", this.flow.getName()), cause);
            }
        }
    }

    public void clearEvent() {
        this.setEvent(null);
    }

    private org.mule.munit.common.model.Event buildEvent(MuleSession session, Event event) {
        org.mule.munit.common.model.Event munitEvent = new org.mule.munit.common.model.Event();
        munitEvent.setPayload(this.buildPayload(event));
        munitEvent.setAttributes(this.buildAttributes(event));
        munitEvent.setError(this.buildError(event));
        munitEvent.setVariables(this.buildVariables(event));
        munitEvent.setSessionProperties(this.buildSessionProperties(session));
        return munitEvent;
    }

    private Payload buildPayload(Event event) {
        TypedValue corePayload = event.getMessage().getPayload();
        MediaType coreMediaType = corePayload.getDataType().getMediaType();
        Payload munitPayload = new Payload();
        munitPayload.setValue(corePayload.getValue());
        munitPayload.setMediaType(coreMediaType.withoutParameters().toString());
        coreMediaType.getCharset().ifPresent(charset -> munitPayload.setEncoding(charset.toString()));
        return munitPayload;
    }

    private EventAttributes buildAttributes(Event event) {
        TypedValue coreAttributes = event.getMessage().getAttributes();
        if (coreAttributes != null) {
            EventAttributes munitAttributes = new EventAttributes();
            MediaType coreMediaType = coreAttributes.getDataType().getMediaType();
            munitAttributes.setValue(coreAttributes.getValue());
            munitAttributes.setMediaType(coreMediaType.withoutParameters().toString());
            coreMediaType.getCharset().ifPresent(charset -> munitAttributes.setEncoding(charset.toString()));
            return munitAttributes;
        }
        return null;
    }

    private EventError buildError(Event event) {
        EventError munitError = new EventError();
        if (event.getError().isPresent()) {
            munitError.setCause((Object)((Error)event.getError().get()).getCause());
            munitError.setTypeId(((Error)event.getError().get()).getErrorType().getIdentifier());
        }
        return munitError;
    }

    private List<Variable> buildVariables(Event event) {
        Map coreEventVariables = event.getVariables();
        ArrayList<Variable> munitVariables = new ArrayList<Variable>();
        for (String key : coreEventVariables.keySet()) {
            Variable munitVariable = new Variable();
            munitVariable.setKey(key);
            munitVariable.setValue((Serializable)((TypedValue)coreEventVariables.get(key)).getValue());
            ((TypedValue)coreEventVariables.get(key)).getDataType().getMediaType().getCharset().ifPresent(charset -> munitVariable.setEncoding(charset.toString()));
            MediaType mimeType = ((TypedValue)coreEventVariables.get(key)).getDataType().getMediaType();
            if (!mimeType.equals((Object)MediaType.ANY)) {
                munitVariable.setMediaType(mimeType.withoutParameters().toString());
            }
            munitVariables.add(munitVariable);
        }
        return munitVariables;
    }

    private List<Property> buildSessionProperties(MuleSession session) {
        ArrayList<Property> munitProperties = new ArrayList<Property>();
        for (String key : session.getPropertyNamesAsSet()) {
            if (!(session.getProperty(key) instanceof Serializable)) continue;
            Property munitProperty = new Property();
            munitProperty.setKey(key);
            munitProperty.setValue((Serializable)session.getProperty(key));
            session.getPropertyDataType(key).getMediaType().getCharset().ifPresent(charset -> munitProperty.setEncoding(charset.toString()));
            munitProperty.setMediaType(session.getPropertyDataType(key).getMediaType().withoutParameters().toString());
            munitProperties.add(munitProperty);
        }
        return munitProperties;
    }
}

