/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.common.model.Attribute;
import org.mule.munit.common.model.Event;
import org.mule.munit.mock.tool.ProcessorMocker;
import org.mule.munit.mock.tool.spy.Spy;
import org.mule.munit.mock.tool.spy.SpyProcess;
import org.mule.munit.mock.tool.spy.SpyProcessImpl;
import org.mule.munit.mock.tool.verify.Verifier;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockModule {
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Registry registry;

    public void when(String processor, List<Attribute> withAttributes, Event thenReturn) {
        this.logger.debug("Creating mock behaviour for: " + processor + " - Attributes: " + withAttributes);
        this.mocker().when(ProcessorId.getName((String)processor)).ofNamespace(ProcessorId.getNamespace((String)processor)).withAttributes(this.createAttributes(withAttributes)).thenReturn(thenReturn);
    }

    public void spy(String processor, List<Attribute> withAttributes, Chain beforeCall, Chain afterCall) {
        this.logger.debug("Creating spy behaviour for: " + processor + " - Attributes: " + withAttributes);
        this.spy().spyProcessor(ProcessorId.getName((String)processor)).ofNamespace(ProcessorId.getNamespace((String)processor)).withAttributes(this.createAttributes(withAttributes)).before(this.createSpyProcesses(beforeCall)).after(this.createSpyProcesses(afterCall));
    }

    public void verifyCall(String processor, List<Attribute> attributes, Integer times, Integer atLeast, Integer atMost) {
        try {
            Verifier mockVerifier = this.verifier().verifyCallOfProcessor(ProcessorId.getName((String)processor)).ofNamespace(ProcessorId.getNamespace((String)processor)).withAttributes(this.createAttributes(attributes));
            if (times != null) {
                mockVerifier.times(times);
            } else if (atLeast != null) {
                mockVerifier.atLeast(atLeast);
            } else if (atMost != null) {
                mockVerifier.atMost(atMost);
            } else {
                mockVerifier.atLeastOnce();
            }
        }
        catch (AssertionError error) {
            AssertionError assertionException = new AssertionError((Object)this.getMessage(error, "Verify Processor Failed"));
            throw assertionException;
        }
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    private Map<String, Object> createAttributes(List<Attribute> attributes) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (attributes == null) {
            return attrs;
        }
        for (Attribute attr : attributes) {
            attrs.put(attr.getAttributeName(), attr.getWhereValue());
        }
        return attrs;
    }

    private List<SpyProcess> createSpyProcesses(Chain processorsFrom) {
        return processorsFrom == null ? Collections.emptyList() : Collections.singletonList(this.createSpy(processorsFrom));
    }

    protected SpyProcess createSpy(Chain processorsFrom) {
        return new SpyProcessImpl(processorsFrom);
    }

    protected ProcessorMocker mocker() {
        return new ProcessorMocker(this.registry);
    }

    protected Verifier verifier() {
        return new Verifier(this.registry);
    }

    protected Spy spy() {
        return new Spy(this.registry);
    }

    private String getMessage(AssertionError error, String defaultValue) {
        String message = ((Throwable)((Object)error)).getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return defaultValue;
        }
        return message;
    }
}

