/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.processors;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.mock.MockModule;
import org.mule.munit.mock.processors.AbstractMockMessageProcessor;

public class ThrowAnMessageProcessor
extends AbstractMockMessageProcessor {
    public static final String MESSAGE_PROCESSOR_NAME = "throw-an";
    protected Object exception;
    protected Object whenCalling;
    protected Object withAttributes;

    public void setWhenCalling(Object value) {
        this.whenCalling = value;
    }

    public void setWithAttributes(Object value) {
        this.withAttributes = value;
    }

    public void setException(Object value) {
        this.exception = value;
    }

    @Override
    protected void doProcess(MuleEvent muleEvent, MockModule module) throws Exception {
        MuleMessage mulemessage = muleEvent.getMessage();
        Object exceptionToThrow = this.evaluate(mulemessage, this.exception);
        if (!Throwable.class.isAssignableFrom(exceptionToThrow.getClass())) {
            throw new MunitError("The MEL expression for the exception to throw didn't return an instance of java.lang.Throwable");
        }
        Throwable throwable = (Throwable)exceptionToThrow;
        module.throwAn(throwable, (String)this.whenCalling, this.transformAttributes(this.withAttributes, muleEvent));
    }

    @Override
    protected String getProcessor() {
        return MESSAGE_PROCESSOR_NAME;
    }
}

