/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.config;

import org.mule.munit.api.spring.config.parsers.MunitDefinitionParser;
import org.mule.munit.api.spring.config.parsers.MunitGenericDefinitionParser;
import org.mule.munit.api.spring.config.parsers.model.ChildElement;
import org.mule.munit.api.spring.config.parsers.model.ListChildElement;
import org.mule.munit.api.spring.config.parsers.model.MapChildElement;
import org.mule.munit.api.spring.config.parsers.model.NestedChildElement;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;
import org.mule.munit.common.model.Property;
import org.mule.munit.mock.MockModule;
import org.mule.munit.mock.model.Attribute;
import org.mule.munit.mock.model.MunitMuleMessage;
import org.mule.munit.mock.processors.OutboundEndpointMessageProcessor;
import org.mule.munit.mock.processors.SpyMessageProcessor;
import org.mule.munit.mock.processors.ThrowAnMessageProcessor;
import org.mule.munit.mock.processors.VerifyCallMessageProcessor;
import org.mule.munit.mock.processors.WhenMessageProcessor;
import org.mule.munit.mock.spring.config.AbstractMockNamespaceHandler;

public class MockNamespaceHandler
extends AbstractMockNamespaceHandler {
    public static final String CONFIG_MP = "config";
    public static final String OUTBOUND_ENDPOINT_MP = "outbound-endpoint";
    public static final String SPY_MP = "spy";
    public static final String THROW_AN_MP = "throw-an";
    public static final String VERIFY_CALL_MP = "verify-call";
    public static final String WHEN_MP = "when";
    public static final String CONFIG_REF_ATT_NAME = "config-ref";
    public static final String WITH_ATTRIBUTES_ATT_NAME = "with-attributes";

    protected void declareBeanDefinitionParsers() {
        this.declareBeanDefinitionParser(CONFIG_MP, (MunitDefinitionParser)this.buildMockModuleDefinitionParser());
        this.declareBeanDefinitionParser(OUTBOUND_ENDPOINT_MP, (MunitDefinitionParser)this.buildOutboundEndpointDefinitionParser());
        this.declareBeanDefinitionParser(SPY_MP, (MunitDefinitionParser)this.buildSpyDefinitionParser());
        this.declareBeanDefinitionParser(THROW_AN_MP, (MunitDefinitionParser)this.buildThrowAnDefinitionParser());
        this.declareBeanDefinitionParser(VERIFY_CALL_MP, (MunitDefinitionParser)this.buildVerifyCallDefinitionParser());
        this.declareBeanDefinitionParser(WHEN_MP, (MunitDefinitionParser)this.buildWhenDefinitionParser());
    }

    private MunitGenericDefinitionParser buildMockModuleDefinitionParser() {
        MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder(MockModule.class);
        builder = builder.withScope("singleton").withNoAttachProcessorDefinition();
        return builder.build();
    }

    private MunitGenericDefinitionParser buildOutboundEndpointDefinitionParser() {
        MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder(OutboundEndpointMessageProcessor.class);
        builder = builder.withScope("prototype").withAttribute(CONFIG_REF_ATT_NAME, "moduleObject").withAttribute("address", "address").withAttribute("returnPayload", "returnPayload").withAttribute("exception-ref", "exception").withAttribute("thenApplyTransformer-ref", "thenApplyTransformer").withChildElement("return-invocation-properties", this.buildMapChildElement("return-invocation-properties", "returnInvocationProperties", "return-invocation-property")).withChildElement("return-inbound-properties", this.buildMapChildElement("return-inbound-properties", "returnInboundProperties", "return-inbound-property")).withChildElement("return-session-properties", this.buildMapChildElement("return-session-properties", "returnSessionProperties", "return-session-property")).withChildElement("return-outbound-properties", this.buildMapChildElement("return-outbound-properties", "returnOutboundProperties", "return-outbound-property")).withChildElement("assertions", (ParseableElement)this.buildNestedChildElement("assertions", "assertions"));
        return builder.build();
    }

    private MunitGenericDefinitionParser buildSpyDefinitionParser() {
        MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder(SpyMessageProcessor.class);
        builder = builder.withScope("prototype").withAttribute(CONFIG_REF_ATT_NAME, "moduleObject").withAttribute("messageProcessor", "messageProcessor").withChildElement(WITH_ATTRIBUTES_ATT_NAME, this.buildWithAttributesListlement()).withChildElement("assertions-before-call", (ParseableElement)this.buildNestedChildElement("assertions-before-call", "assertionsBeforeCall")).withChildElement("assertions-after-call", (ParseableElement)this.buildNestedChildElement("assertions-after-call", "assertionsAfterCall"));
        return builder.build();
    }

    private MunitGenericDefinitionParser buildThrowAnDefinitionParser() {
        MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder(ThrowAnMessageProcessor.class);
        builder = builder.withScope("prototype").withAttribute(CONFIG_REF_ATT_NAME, "moduleObject").withAttribute("exception-ref", "exception").withAttribute("whenCalling", "whenCalling").withChildElement(WITH_ATTRIBUTES_ATT_NAME, this.buildWithAttributesListlement());
        return builder.build();
    }

    private MunitGenericDefinitionParser buildVerifyCallDefinitionParser() {
        MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder(VerifyCallMessageProcessor.class);
        builder = builder.withScope("prototype").withAttribute(CONFIG_REF_ATT_NAME, "moduleObject").withAttribute("messageProcessor", "messageProcessor").withAttribute("times", "times").withAttribute("atLeast", "atLeast").withAttribute("atMost", "atMost").withChildElement(WITH_ATTRIBUTES_ATT_NAME, this.buildWithAttributesListlement());
        return builder.build();
    }

    private MunitGenericDefinitionParser buildWhenDefinitionParser() {
        MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder builder = new MunitGenericDefinitionParser.MunitGenericDefinitionParserBuilder(WhenMessageProcessor.class);
        builder = builder.withScope("prototype").withAttribute(CONFIG_REF_ATT_NAME, "moduleObject").withAttribute("messageProcessor", "messageProcessor").withChildElement(WITH_ATTRIBUTES_ATT_NAME, this.buildWithAttributesListlement()).withAttribute("thenApplyTransformer-ref", "thenApplyTransformer").withChildElement("then-return", this.buildThenReturnChildElement());
        return builder.build();
    }

    private ParseableElement buildWithAttributesListlement() {
        ListChildElement.ListChildElementBuilder builder = new ListChildElement.ListChildElementBuilder(WITH_ATTRIBUTES_ATT_NAME, "withAttributes");
        builder.withItemClass(Attribute.class).withItemName("with-attribute").withItemAttribute("name", "name").withItemAttribute("whereValue", "whereValue");
        return builder.build();
    }

    private ParseableElement buildThenReturnChildElement() {
        ChildElement.ChildElementBuilder builder = new ChildElement.ChildElementBuilder(MunitMuleMessage.class);
        builder.withElementName("then-return").withElementPropertyName("thenReturn").withAttribute("payload", "payload").withAttribute("mimeType", "mimeType").withAttribute("encoding", "encoding").withChildElement(this.buildPropertiesListlement("invocation-properties", "invocationProperties", "invocation-property")).withChildElement(this.buildPropertiesListlement("inbound-properties", "inboundProperties", "inbound-property")).withChildElement(this.buildPropertiesListlement("session-properties", "sessionProperties", "session-property")).withChildElement(this.buildPropertiesListlement("outbound-properties", "outboundProperties", "outbound-property"));
        return builder.build();
    }

    private ParseableElement buildPropertiesListlement(String elementName, String elementPropertyName, String elementItemName) {
        ListChildElement.ListChildElementBuilder builder = new ListChildElement.ListChildElementBuilder(elementName, elementPropertyName);
        builder.withItemClass(Property.class).withItemName(elementItemName).withItemAttribute("key", "key").withItemAttribute("value", "value").withItemAttribute("mimeType", "mimeType").withItemAttribute("encoding", "encoding");
        return builder.build();
    }

    private ParseableElement buildMapChildElement(String elementName, String elementPropertyName, String elementItemName) {
        MapChildElement.MapChildElementBuilder builder = new MapChildElement.MapChildElementBuilder(elementName, elementPropertyName);
        builder.withItemName(elementItemName);
        return builder.build();
    }

    private NestedChildElement buildNestedChildElement(String elementName, String elementPropertyName) {
        NestedChildElement.NestedChildElementBuilder builder = new NestedChildElement.NestedChildElementBuilder();
        builder.withElementName(elementName).withElementPropertyName(elementPropertyName);
        return builder.build();
    }
}

