/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.util;

import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;

import java.util.List;
import java.util.Set;

import static java.util.stream.Collectors.toList;

/**
 * <p>
 * {@link SuiteResult} utils class
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.2.3
 */
public class SuiteResultUtils {

  /**
   * If there is an error while deploying the application, it creates a {@link SuiteResult}
   * used for {@link org.mule.munit.plugin.maven.runner.printer.XmlResultPrinter} and
   * {@link org.mule.munit.plugin.maven.runner.printer.MavenResultPrinter}
   */
  public static List<SuiteResult> createErrorSuites(RunResult runResult, Set<String> suitePaths) {
    return suitePaths.stream()
        .map(path -> newErrorSuite(runResult, path))
        .collect(toList());
  }

  private static SuiteResult newErrorSuite(RunResult runResult, String path) {
    SuiteResult suiteResult = new SuiteResult();
    suiteResult.setSuiteError(true);
    suiteResult.setCause(runResult.getStackTrace());
    suiteResult.setSuitePath(path);
    suiteResult.setRuntimeStartFailed(true);
    return suiteResult;
  }

}
