/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

/**
 * <p>
 * Generates the jar file for the new JVM
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class JarFileFactory {

  private static final String MANIFEST_VERSION = "1.0";

  public File create(List<String> classPath, String startClassName, File buildDirectory, String fileName) throws IOException {
    File file = new File(buildDirectory, fileName);
    file.deleteOnExit();
    FileOutputStream fileOutputStream = new FileOutputStream(file);
    try (JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream)) {
      jarOutputStream.setLevel(JarOutputStream.STORED);
      JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
      jarOutputStream.putNextEntry(je);

      Manifest manifest = new Manifest();
      StringBuilder cp = new StringBuilder();
      for (String el : classPath) {
        cp.append(new File(el).toURI().toURL().toExternalForm()).append(" ");
      }

      manifest.getMainAttributes().putValue("Manifest-Version", MANIFEST_VERSION);
      manifest.getMainAttributes().putValue("Class-Path", cp.toString().trim());
      manifest.getMainAttributes().putValue("Main-Class", startClassName);

      manifest.write(jarOutputStream);
    }

    return file;
  }

}
