/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.locators;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;

/**
 * <p>
 * Locates all MUnit suite files
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class TestSuiteFilesLocator extends TestConfigFilesLocator {

  private static final String MUNIT_TEST_SUITE_FILE_MARKER = "munit:config";

  public List<File> locateFiles(File folder) {
    return super.locateFiles(folder).stream().filter(this::isValidMunitTestSuiteFile).collect(Collectors.toList());
  }

  private boolean isValidMunitTestSuiteFile(File file) {
    Scanner scanner = null;
    try {
      // TODO improve this lovely code
      scanner = new Scanner(file, UTF_8.name());
      while (scanner.hasNextLine()) {
        String line = scanner.nextLine();
        if (line.contains(MUNIT_TEST_SUITE_FILE_MARKER)) {
          scanner.close();
          return true;
        }
      }

    } catch (FileNotFoundException e) {
      return false;
    } finally {
      if (null != scanner) {
        scanner.close();

      }
    }
    return false;
  }
}
