/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.locators;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.munit.common.util.Collections;
import org.mule.munit.common.util.Preconditions;

public class RemoteRepositoriesLocator {
    private List<RemoteRepository> remoteRepositories;
    private List<String> whitelistRepositories = java.util.Collections.emptyList();

    public RemoteRepositoriesLocator(MavenProject mavenProject) {
        Preconditions.checkArgument((mavenProject != null ? 1 : 0) != 0, (String)"Maven Project cannot be null");
        this.remoteRepositories = mavenProject.getRemoteProjectRepositories();
    }

    public RemoteRepositoriesLocator setWhiteListRepositories(List<String> whitelistRepositories) {
        Preconditions.checkArgument((whitelistRepositories != null ? 1 : 0) != 0, (String)"Whitelist repositories cannot be null");
        this.whitelistRepositories = whitelistRepositories;
        return this;
    }

    public List<String> getWhitelistedRepositories() {
        return this.whitelistRepositories;
    }

    public List<RemoteRepository> locateAll() {
        return this.remoteRepositories;
    }

    public List<RemoteRepository> locate() {
        return Collections.isEmpty(this.whitelistRepositories) ? this.remoteRepositories : this.filterRepositories(this.remoteRepositories);
    }

    private List<RemoteRepository> filterRepositories(List<RemoteRepository> repositories) {
        return repositories.stream().filter(this::isWhiteListed).collect(Collectors.toList());
    }

    private boolean isWhiteListed(RemoteRepository remoteRepository) {
        return this.whitelistRepositories.stream().anyMatch(whitelistedRepo -> remoteRepository.getUrl().startsWith((String)whitelistedRepo));
    }
}

