/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runtime;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.Preconditions;
import org.mule.runtime.api.meta.MuleVersion;

@Deprecated
public class TargetRuntime
implements Comparable<TargetRuntime> {
    public static final String CE = "MULE";
    public static final String EE = "MULE_EE";
    private static final List<String> PRODUCTS = Arrays.asList("MULE", "MULE_EE");
    private static final String TARGET_RUNTIME_SEPARATOR = ":";
    private final MuleVersion runtimeVersion;
    private final String runtimeProduct;

    public TargetRuntime(String runtimeVersion, String runtimeProduct) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)runtimeVersion), (String)"Version cannot be blank");
        this.runtimeVersion = new MuleVersion(runtimeVersion);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)runtimeProduct), (String)"Product cannot be blank");
        Preconditions.checkArgument((boolean)PRODUCTS.contains(runtimeProduct), (String)String.format("Invalid product: %s", runtimeProduct));
        this.runtimeProduct = runtimeProduct;
    }

    public static TargetRuntime parse(String targetRuntime) {
        String[] versionAndProduct = StringUtils.split((String)targetRuntime, (String)TARGET_RUNTIME_SEPARATOR);
        if (versionAndProduct.length != 2) {
            throw new IllegalArgumentException("Target runtime should be in the form of <product>:<version>. For example MULE_EE:4.1.1");
        }
        String product = versionAndProduct[0];
        String version = versionAndProduct[1];
        return new TargetRuntime(version, product);
    }

    public String getRuntimeProduct() {
        return this.runtimeProduct;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetRuntime that = (TargetRuntime)o;
        return this.runtimeVersion.equals((Object)that.runtimeVersion) && this.runtimeProduct.equals(that.runtimeProduct);
    }

    public int hashCode() {
        int result = this.runtimeVersion != null ? this.runtimeVersion.hashCode() : 0;
        result = 31 * result + (this.runtimeProduct != null ? this.runtimeProduct.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.runtimeProduct + TARGET_RUNTIME_SEPARATOR + this.runtimeVersion.toString();
    }

    @Override
    public int compareTo(TargetRuntime that) {
        if (that == null) {
            throw new NullPointerException("Can't compare against null");
        }
        if (this.equals(that)) {
            return 0;
        }
        if (this.runtimeProduct.equals(that.runtimeProduct)) {
            return this.runtimeVersion.newerThan(that.runtimeVersion) ? 1 : -1;
        }
        return this.runtimeProduct.equals(CE) ? -1 : 1;
    }
}

