/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.locators;

import java.io.File;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

import static org.apache.commons.lang3.StringUtils.isEmpty;

/**
 * <p>
 * Locates the java executable daemon
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class JVMLocator {

  private Log log;
  private MavenSession session;
  private ToolchainManager toolchainManager;
  private String jvm;

  public JVMLocator(MavenSession session, String jvm, ToolchainManager toolchainManager, Log log) {
    this.log = log;
    this.session = session;
    this.jvm = jvm;
    this.toolchainManager = toolchainManager;
  }

  public String locate() {
    String jvmToUse = this.jvm;
    Toolchain toolchain = getToolchain();
    if (toolchain != null) {
      log.info("Toolchain: " + toolchain);
      if (isEmpty(jvmToUse)) {
        jvmToUse = toolchain.findTool("java");
      } else {
        log.warn("Toolchain ignored. Parameter 'jvm' was set to " + jvmToUse);
      }
    }

    if (isEmpty(jvmToUse)) {
      jvmToUse = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }
    log.debug("Using JVM: " + jvmToUse);

    return jvmToUse;
  }

  protected Toolchain getToolchain() {
    Toolchain toolchain = null;
    if (toolchainManager != null && session != null) {
      toolchain = toolchainManager.getToolchainFromBuildContext("jdk", session);
    }
    return toolchain;
  }

}
