/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.plugin.maven.locators.Log4J2ConfigurationLocator;
import org.mule.munit.plugin.maven.locators.TestSuiteFilesLocator;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.RunConfigurationFactory;
import org.mule.munit.plugin.maven.util.TestSuiteFileFilter;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.MavenConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;
import org.mule.munit.remote.api.configuration.NotifierParameter;
import org.mule.munit.remote.api.configuration.Repository;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.notifiers.ConsoleNotifier;

public abstract class BaseRunConfigurationFactory
implements RunConfigurationFactory {
    public static final String RUN_TOKEN_CONSOLE_PARAMETER = "runToken";
    private final Log log;
    private final String munitTags;
    private final String projectName;
    private final Boolean skipAfterFailure;
    private final TestSuiteFileFilter testSuiteFileFilter;
    private final WorkingDirectoryGenerator workingDirectoryGenerator;
    private final TargetProduct targetProduct;
    private final Boolean clearParameters;
    private final File munitSrcFolder;
    private final URI defaultMunitSrcFolder;
    private final String runToken;
    private final MavenProject project;
    private final MavenSession session;

    public BaseRunConfigurationFactory(Log log, String projectName, String munitTest, String munitTags, Boolean skipAfterFailure, TargetProduct targetProduct, WorkingDirectoryGenerator workingDirectoryGenerator, File munitSrcFolder, MavenProject project, MavenSession session, Boolean clearParameters) {
        Preconditions.checkNotNull((Object)log, (String)"The log must not be null");
        Preconditions.checkNotNull((Object)skipAfterFailure, (String)"The skipAfterFailure must not be null");
        Preconditions.checkNotNull((Object)targetProduct, (String)"The muleApplicationModelLoader must not be null nor empty");
        Preconditions.checkNotNull((Object)workingDirectoryGenerator, (String)"The WorkingDirectoryGenerator must not be null");
        Preconditions.checkNotNull((Object)munitSrcFolder, (String)"The munitSrcFolder must not be null");
        Preconditions.checkNotNull((Object)project, (String)"The project must not be null");
        Preconditions.checkNotNull((Object)session, (String)"The session must not be null");
        this.log = log;
        this.projectName = projectName;
        this.munitTags = munitTags;
        this.skipAfterFailure = skipAfterFailure;
        this.targetProduct = targetProduct;
        this.testSuiteFileFilter = new TestSuiteFileFilter(log, munitTest);
        this.clearParameters = clearParameters;
        this.munitSrcFolder = munitSrcFolder;
        this.defaultMunitSrcFolder = Paths.get(project.getBuild().getDirectory(), FolderNames.TEST_MULE.value(), FolderNames.MUNIT.value()).toUri();
        this.runToken = UUID.randomUUID().toString();
        this.workingDirectoryGenerator = workingDirectoryGenerator;
        this.project = project;
        this.session = session;
    }

    @Override
    public RunConfiguration create() throws MojoExecutionException {
        return this.getRunConfigurationBuilder().build();
    }

    protected MavenConfiguration.MavenConfigurationBuilder getMavenConfigurationBuilder() {
        DefaultSettingsSupplierFactory defaultSettingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = new MavenConfiguration.MavenConfigurationBuilder();
        mavenConfigurationBuilder.withMavenRepositoryDirectoryPath(this.session.getLocalRepository().getBasedir()).withSettingsXmlFilePath(this.session.getRequest().getUserSettingsFile().getAbsolutePath()).withGlobalSettingsXmlFilePath(this.session.getRequest().getGlobalSettingsFile().getAbsolutePath()).withForcePolicyUpdate(Boolean.valueOf(true)).withActiveProfiles(this.project.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toList())).withOfflineMode(Boolean.valueOf(this.session.isOffline())).withIgnoreArtifactDescriptorRepositories(Boolean.valueOf(false)).withRemoteRepositories(this.getRemoteRepositories());
        defaultSettingsSupplierFactory.environmentSettingsSecuritySupplier().ifPresent(file -> mavenConfigurationBuilder.withSecuritySettingsFilePath(file.getPath()));
        return mavenConfigurationBuilder;
    }

    protected RunConfiguration.RunConfigurationBuilder getRunConfigurationBuilder() throws MojoExecutionException {
        List<RunConfiguration.Test> testNamesWithSuite = this.testSuiteFileFilter.getTestNameRegEx();
        return new RunConfiguration.RunConfigurationBuilder().withRunToken(this.runToken).withProjectName(this.projectName).withTags((Set)(this.munitTags == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(this.munitTags.split(","))))).withSkipAfterFailure(this.skipAfterFailure).withClearParameters(this.clearParameters).withTestNames(testNamesWithSuite.stream().map(RunConfiguration.Test::getName).collect(Collectors.toSet())).withTestNamesWithSuite(testNamesWithSuite).withSuitePaths(this.locateMunitTestSuitesToRun()).withAllSuitePaths(this.locateAllMunitTestSuites()).withNotifierConfigurations(this.getNotifierConfigurations()).withContainerConfiguration(this.getContainerConfigurationBuilder().build()).withDomainLocation(this.workingDirectoryGenerator.generateDomainStructure().map(domainPath -> domainPath.toFile().getAbsolutePath()).orElse(""));
    }

    protected List<NotifierConfiguration> getNotifierConfigurations() {
        ArrayList<NotifierParameter> consoleParameters = new ArrayList<NotifierParameter>();
        consoleParameters.add(new NotifierParameter(RUN_TOKEN_CONSOLE_PARAMETER, String.class.getCanonicalName(), this.runToken));
        NotifierConfiguration consoleNotifierConfiguration = new NotifierConfiguration.NotifierConfigurationBuilder().withClazz(ConsoleNotifier.class.getCanonicalName()).withParameters(consoleParameters).build();
        ArrayList<NotifierConfiguration> notifierConfigurations = new ArrayList<NotifierConfiguration>();
        notifierConfigurations.add(consoleNotifierConfiguration);
        return notifierConfigurations;
    }

    protected abstract ContainerConfiguration.ContainerConfigurationBuilder getContainerConfigurationBuilder();

    protected Set<String> locateAllMunitTestSuites() {
        return new TestSuiteFilesLocator().locateFiles(this.munitSrcFolder).stream().map(suiteFile -> this.defaultMunitSrcFolder.relativize(suiteFile.toURI()).toASCIIString()).collect(Collectors.toSet());
    }

    protected Set<String> locateMunitTestSuitesToRun() {
        return this.locateAllMunitTestSuites().stream().filter(this.testSuiteFileFilter::shouldFilter).collect(Collectors.toSet());
    }

    protected String getLog4JConfigurationFilePath() {
        return this.getLog4JConfigurationFile().isPresent() ? this.getLog4JConfigurationFile().get().getAbsolutePath() : "";
    }

    private Optional<File> getLog4JConfigurationFile() {
        List<File> files = new Log4J2ConfigurationLocator(this.log).locateFiles(new File(this.project.getBuild().getDirectory()));
        return files.isEmpty() ? Optional.empty() : Optional.of(files.get(0));
    }

    private List<Repository> getRemoteRepositories() {
        return this.project.getRemotePluginRepositories().stream().map(r -> new Repository(r.getId(), r.getUrl())).collect(Collectors.toList());
    }

    public WorkingDirectoryGenerator getWorkingDirectoryGenerator() {
        return this.workingDirectoryGenerator;
    }

    public TargetProduct getTargetProduct() {
        return this.targetProduct;
    }
}

