/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.plugin.maven.runtime.ProductDiscoveryMode;

public class DiscoverRuntimes {
    public static final String DISCOVER_RUNTIMES_PRODUCT = "discoverRuntimes.product";
    public static final String DISCOVER_RUNTIMES_INCLUDE_SNAPSHOTS = "discoverRuntimes.includeSnapshots";
    public static final String DISCOVER_RUNTIMES_MIN_MULE_VERSION = "discoverRuntimes.minMuleVersion";
    public static final String DISCOVER_RUNTIMES_SKIP = "discoverRuntimes.skip";
    public static final String DISCOVER_RUNTIMES_REPOSITORIES = "discoverRuntimes.runtimeRepositories";
    public static final String DISCOVER_RUNTIMES_LATEST_PATCHES = "discoverRuntimes.latestPatches";
    private static final String DISCOVER_RUNTIMES_REPOSITORIES_SEPARATOR = ",";
    private ProductDiscoveryMode product;
    private String minMuleVersion;
    private boolean includeSnapshots = false;
    private boolean skip = false;
    private boolean latestPatches = true;
    private List<String> runtimeRepositories = Collections.emptyList();

    public DiscoverRuntimes() {
    }

    private DiscoverRuntimes(ProductDiscoveryMode product, String minMuleVersion, boolean includeSnapshots, boolean skip, List<String> runtimeRepositories, boolean uselatestPatches) {
        this.product = product;
        this.minMuleVersion = minMuleVersion;
        this.includeSnapshots = includeSnapshots;
        this.skip = skip;
        this.runtimeRepositories = runtimeRepositories;
        this.latestPatches = uselatestPatches;
    }

    public Optional<String> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    public Optional<ProductDiscoveryMode> getProduct() {
        return Optional.ofNullable(this.product);
    }

    public boolean isIncludeSnapshots() {
        return this.includeSnapshots;
    }

    public boolean isSkipped() {
        return this.skip;
    }

    public boolean isUseLatestPatches() {
        return this.latestPatches;
    }

    public List<String> getRuntimeRepositories() {
        return this.runtimeRepositories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ProductDiscoveryMode product;
        private String minMuleVersion;
        private boolean includeSnapshots = false;
        private boolean skip;
        private boolean useLatestPatches = true;
        private List<String> runtimeRepositories = Collections.emptyList();

        public Builder from(DiscoverRuntimes discoverRuntimes) {
            if (discoverRuntimes == null) {
                this.skip = true;
                return this;
            }
            discoverRuntimes.getMinMuleVersion().ifPresent(minMuleVersion -> {
                this.minMuleVersion = minMuleVersion;
            });
            discoverRuntimes.getProduct().ifPresent(productDiscoveryMode -> {
                this.product = productDiscoveryMode;
            });
            this.includeSnapshots = discoverRuntimes.isIncludeSnapshots();
            this.skip = discoverRuntimes.isSkipped();
            this.useLatestPatches = discoverRuntimes.isUseLatestPatches();
            this.runtimeRepositories = discoverRuntimes.getRuntimeRepositories();
            return this;
        }

        public Builder withProduct(ProductDiscoveryMode productDiscoveryMode) {
            this.product = productDiscoveryMode;
            return this;
        }

        public Builder withMinMuleVersion(String minMuleVersion) {
            this.minMuleVersion = minMuleVersion;
            return this;
        }

        public Builder includingSnapshots(Boolean includeSnapshots) {
            this.includeSnapshots = includeSnapshots;
            return this;
        }

        public Builder skip(Boolean skip) {
            this.skip = skip;
            return this;
        }

        public Builder useLatestPatches(Boolean useLatestPatches) {
            this.useLatestPatches = useLatestPatches;
            return this;
        }

        public Builder withRuntimeRepositories(List<String> runtimeRepositories) {
            this.runtimeRepositories = runtimeRepositories;
            return this;
        }

        public Builder withOverrides(Properties userProperties) {
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_INCLUDE_SNAPSHOTS)) {
                this.includeSnapshots = Boolean.valueOf(userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_INCLUDE_SNAPSHOTS));
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_PRODUCT)) {
                this.product = ProductDiscoveryMode.valueOf(userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_PRODUCT));
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_MIN_MULE_VERSION)) {
                this.minMuleVersion = userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_MIN_MULE_VERSION);
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_SKIP)) {
                this.skip = Boolean.valueOf(userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_SKIP));
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_REPOSITORIES)) {
                this.runtimeRepositories = Arrays.asList(StringUtils.split((String)userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_REPOSITORIES), (String)DiscoverRuntimes.DISCOVER_RUNTIMES_REPOSITORIES_SEPARATOR));
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_LATEST_PATCHES)) {
                this.useLatestPatches = Boolean.valueOf(userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_LATEST_PATCHES));
            }
            return this;
        }

        public DiscoverRuntimes build() {
            return new DiscoverRuntimes(this.product, this.minMuleVersion, this.includeSnapshots, this.skip, this.runtimeRepositories, this.useLatestPatches);
        }
    }
}

