/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.consumer;

import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.MessageField;
import org.mule.munit.common.protocol.message.RunMessageParser;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.plugin.maven.runner.handler.RunnerMessageHandler;
import org.mule.munit.plugin.maven.runner.model.RunResult;

public class RunnerStreamConsumer
implements StreamConsumer {
    private RunResult runResult = new RunResult();
    private RunnerMessageHandler runnerMessageHandler;
    private RunMessageParser runnerParser;

    public RunnerStreamConsumer(RunnerMessageHandler runnerMessageHandler) {
        this.runnerMessageHandler = runnerMessageHandler;
        this.runnerParser = new RunMessageParser((RunEventListener)new RunStreamConsumerEventListener());
    }

    public void consumeLine(String s) {
        if (s.startsWith(MessageField.FIELD_TOKEN)) {
            this.handleProtocolLine(s.replace(MessageField.FIELD_TOKEN, "").replaceAll(MessageField.NEW_LINE_ESCAPE_TOKEN, System.lineSeparator()));
        } else {
            this.runnerMessageHandler.handleStandardOutputLine(s);
        }
    }

    protected void handleProtocolLine(String message) {
        this.runnerParser.parseAndNotify(message);
    }

    public RunResult getRunResult() {
        this.runnerMessageHandler.handleRunResult(this.runResult);
        return this.runResult;
    }

    private void notifyBeforeOrAfterSuite(String stackTrace, TestStatus status) {
        switch (status) {
            case ERROR: {
                this.runResult.suiteError(stackTrace);
                this.runnerMessageHandler.handleSuiteError(this.runResult.getCurrentSuite());
                break;
            }
            case FAILURE: {
                this.runResult.suiteFailure(stackTrace);
                this.runnerMessageHandler.handleSuiteFailure(this.runResult.getCurrentSuite());
            }
        }
    }

    private class RunStreamConsumerEventListener
    implements RunEventListener {
        private RunStreamConsumerEventListener() {
        }

        public void notifyRunFinish() {
            RunnerStreamConsumer.this.runResult.setRunFinished(true);
        }

        public void notifyCoverageReport(String coverageReportJson) {
            RunnerStreamConsumer.this.runResult.setCoverageReport(coverageReportJson);
        }

        public void notifySuiteStart(String suite, String parameterization, int numberOfTests) {
            RunnerStreamConsumer.this.runResult.testSuiteStarted(suite, parameterization);
            RunnerStreamConsumer.this.runnerMessageHandler.handleSuiteStart(suite, parameterization);
        }

        public void notifyContainerFailure(String stackTrace) {
            RunnerStreamConsumer.this.runResult.containerStartFailed(stackTrace);
            RunnerStreamConsumer.this.runnerMessageHandler.handleSuiteStartFailure(stackTrace);
        }

        public void notifyContainerFailure(String suite, String parameterization, String stackTrace) {
            RunnerStreamConsumer.this.runResult.testSuiteStartFailed(suite, parameterization, stackTrace);
            RunnerStreamConsumer.this.runnerMessageHandler.handleSuiteStartFailure(suite, parameterization, stackTrace);
        }

        public void notifyBeforeSuiteEnd(String name, String stackTrace, TestStatus status) {
            RunnerStreamConsumer.this.notifyBeforeOrAfterSuite(stackTrace, status);
        }

        public void notifyTestStart(String name, String description, boolean isIgnored) {
            RunnerStreamConsumer.this.runResult.testStarted(name);
        }

        public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
            switch (status) {
                case SUCCESS: {
                    RunnerStreamConsumer.this.runResult.testFinished(name, elapsedTime);
                    break;
                }
                case FAILURE: {
                    RunnerStreamConsumer.this.runResult.testFailure(name, stackTrace, elapsedTime);
                    break;
                }
                case IGNORED: {
                    RunnerStreamConsumer.this.runResult.testIgnored(name, elapsedTime);
                    break;
                }
                case ERROR: {
                    RunnerStreamConsumer.this.runResult.testError(name, stackTrace, elapsedTime);
                }
            }
        }

        public void notifyAfterSuiteEnd(String name, String stackTrace, TestStatus status) {
            RunnerStreamConsumer.this.notifyBeforeOrAfterSuite(stackTrace, status);
        }

        public void notifySuiteEnd(String suite, String parameterization, long elapsedTime) {
            RunnerStreamConsumer.this.runResult.suiteFinished(elapsedTime);
            RunnerStreamConsumer.this.runnerMessageHandler.handleSuiteFinished(RunnerStreamConsumer.this.runResult.getSuite(suite, parameterization));
        }

        public void notifyUnexpectedError(String stackTrace) {
            RunnerStreamConsumer.this.runResult.unexpectedError(stackTrace);
            RunnerStreamConsumer.this.runnerMessageHandler.handleUnexpectedError(stackTrace);
        }

        public void notifySuiteUnexpectedError(String name, String stackTrace) {
            RunnerStreamConsumer.this.runResult.testSuiteUnexpectedError(name, stackTrace);
            RunnerStreamConsumer.this.runnerMessageHandler.handleUnexpectedError(stackTrace);
        }
    }
}

