/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.printer;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;
import org.mule.munit.plugin.maven.runner.model.TestResult;
import org.mule.munit.plugin.maven.runner.printer.ResultPrinter;

public class MavenResultPrinter
implements ResultPrinter {
    private static final String ERROR_TAG = "ERROR";
    private static final String FAILURE_TAG = "FAILED";
    private static final String SEPARATOR_TAG = " <<< ";
    private static final int MAX_RUN_STACKTRACE = 100;
    private static final int MAX_SUITE_STACKTRACE = 50;
    private Log log;

    public MavenResultPrinter(Log log) {
        this.log = log;
    }

    @Override
    public void print(TargetRuntime runtime, RunResult runResult) {
        this.log.info((CharSequence)"====================================================================================");
        this.log.info((CharSequence)String.format("MUnit Run Summary - Product: %s, Version: %s", runtime.getRuntimeProduct(), runtime.getRuntimeVersion()));
        this.log.info((CharSequence)"====================================================================================");
        this.printRunStackTraceIfPresent(runResult);
        int testCount = runResult.getNumberOfTests();
        int errorCount = runResult.getNumberOfErrors();
        int failCount = runResult.getNumberOfFailures();
        int skipCount = runResult.getNumberOfIgnores();
        for (SuiteResult suiteResult : runResult.getSuites()) {
            List<TestResult> failingTests = suiteResult.getFailingTests();
            List<TestResult> errorTests = suiteResult.getErrorTests();
            this.printSuiteResult(suiteResult);
            this.printFailures(failingTests, this.log);
            this.printError(errorTests, this.log);
        }
        this.log.info((CharSequence)"\t");
        this.log.info((CharSequence)"====================================================================================");
        this.log.info((CharSequence)(" > Tests:   \t" + testCount));
        this.log.info((CharSequence)(" > Errors:  \t" + errorCount));
        this.log.info((CharSequence)(" > Failures:\t" + failCount));
        this.log.info((CharSequence)(" > Skipped: \t" + skipCount));
        this.log.info((CharSequence)"====================================================================================");
    }

    private void printRunStackTraceIfPresent(RunResult runResult) {
        if (runResult.hasFailed() && StringUtils.isNotBlank((CharSequence)runResult.getStackTrace())) {
            String stackTrace = runResult.getStackTrace().substring(0, 100);
            if (runResult.isRuntimeStartFailed()) {
                this.log.error((CharSequence)("Run failed to start: " + stackTrace + "..."));
            } else {
                this.log.error((CharSequence)("An error occurred: " + stackTrace + "..."));
            }
        }
    }

    private void printSuiteResult(SuiteResult suiteResult) {
        String unsuccessfulTag = "";
        if (suiteResult.isSuiteFailed() || suiteResult.isSuiteError() || suiteResult.isRuntimeStartFailed()) {
            unsuccessfulTag = SEPARATOR_TAG;
            unsuccessfulTag = unsuccessfulTag + (suiteResult.isSuiteFailed() ? FAILURE_TAG : ERROR_TAG);
            unsuccessfulTag = unsuccessfulTag + " (" + suiteResult.getCause().substring(0, 50) + "...)";
        }
        String suiteResultString = (suiteResult.getNumberOfTests() == 0 ? " (No tests run)" : this.getSuiteResultSummary(suiteResult)) + unsuccessfulTag;
        this.log.info((CharSequence)(" >> " + suiteResult.getSuitePath() + this.getParameterization(suiteResult) + suiteResultString));
    }

    private void printFailures(List<TestResult> failingTests, Log log) {
        this.printUnsuccessfulTests(failingTests, FAILURE_TAG, log);
    }

    private void printError(List<TestResult> errorTests, Log log) {
        this.printUnsuccessfulTests(errorTests, ERROR_TAG, log);
    }

    private void printUnsuccessfulTests(List<TestResult> unsuccessfulTests, String unsuccessfulTag, Log log) {
        if (!unsuccessfulTests.isEmpty()) {
            for (TestResult result : unsuccessfulTests) {
                log.info((CharSequence)("\t --- " + result.getTestName() + SEPARATOR_TAG + unsuccessfulTag));
            }
        }
    }

    private String getParameterization(SuiteResult suiteResult) {
        return suiteResult.getParameterization().map(parametrization -> "[" + parametrization + "]").orElse("");
    }

    private String getSuiteResultSummary(SuiteResult suiteResult) {
        return " test result: Tests: " + suiteResult.getNumberOfTests() + ", Errors: " + suiteResult.getNumberOfErrors() + ", Failures: " + suiteResult.getNumberOfFailures() + ", Skipped: " + suiteResult.getNumberOfIgnores();
    }
}

