/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;

public class ApplicationMuleArtifactJsonGenerator {
    protected static final String EXPORTED_RESOURCES = "exportedResources";
    protected static final String EXPORTED_PACKAGES = "exportedPackages";
    protected static final String INCLUDE_TEST_DEPENDENCIES = "includeTestDependencies";
    private Set<String> configs;
    private Set<String> exportedResources;
    private Set<String> exportedPackages;

    public ApplicationMuleArtifactJsonGenerator(Set<String> configs, Set<String> exportedResources, Set<String> exportedPackages) {
        this.configs = configs;
        this.exportedResources = exportedResources;
        this.exportedPackages = exportedPackages;
    }

    public MuleApplicationModel generate(MuleApplicationModel originalMuleApplicationModel) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setConfigs(this.configs);
        builder.setMinMuleVersion(originalMuleApplicationModel.getMinMuleVersion());
        builder.setName(originalMuleApplicationModel.getName());
        builder.setRedeploymentEnabled(true);
        builder.setRequiredProduct(originalMuleApplicationModel.getRequiredProduct());
        builder.setSecureProperties(originalMuleApplicationModel.getSecureProperties());
        builder.withBundleDescriptorLoader(originalMuleApplicationModel.getBundleDescriptorLoader());
        builder.withClassLoaderModelDescriptorLoader(this.getClassLoaderModelLoaderDescriptor(originalMuleApplicationModel));
        return (MuleApplicationModel)builder.build();
    }

    private MuleArtifactLoaderDescriptor getClassLoaderModelLoaderDescriptor(MuleApplicationModel originalMuleApplicationModel) {
        MuleArtifactLoaderDescriptor descriptor = originalMuleApplicationModel.getClassLoaderModelLoaderDescriptor();
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(descriptor.getAttributes());
        this.overrideValues(newAttributes, EXPORTED_RESOURCES, this.exportedResources);
        this.overrideValues(newAttributes, EXPORTED_PACKAGES, this.cleanse(this.exportedPackages, (Collection)newAttributes.get(EXPORTED_PACKAGES)));
        newAttributes.put(INCLUDE_TEST_DEPENDENCIES, Boolean.TRUE.toString());
        return new MuleArtifactLoaderDescriptor(descriptor.getId(), newAttributes);
    }

    private void overrideValues(Map<String, Object> attributes, String key, Set<String> newValues) {
        attributes.put(key, newValues);
    }

    private Set<String> cleanse(Set<String> values, Collection<String> remove) {
        if (remove != null && remove.size() > 0) {
            return new HashSet<String>((Collection<String>)Sets.difference(values, new HashSet<String>(remove)));
        }
        return values;
    }
}

