/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;

import java.util.List;

/**
 * Utility classes to deal with Maven projects
 *
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public class ProjectUtils {

  public static List<Dependency> getPluginDependencies(MavenProject project, String artifactId) {
    Plugin munitPlugin = project.getBuild().getPlugins().stream()
        .filter(p -> p.getArtifactId().equals(artifactId))
        .findAny()
        .orElseThrow(() -> new IllegalStateException("No [" + artifactId + "] defined in the pom.xml"));
    return munitPlugin.getDependencies();
  }
}
