/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.munit.extension.maven.internal.generator.maven.PluginPomEnricher;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMavenPluginEnricher
extends PluginPomEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleMavenPluginEnricher.class);
    public static final String MAVEN_TOOLS_GROUP_ID = "org.mule.tools.maven";
    public static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String SHARED_LIBRARY_ELEMENT = "sharedLibrary";
    public static final String SHARED_LIBRARIES_ELEMENT = "sharedLibraries";
    public static final String COMPILE_SCOPE = "compile";
    private final List<SharedLibraryDependency> parameterizedSharedLibraries;
    private final String packagerVersion;
    private final ExtensionModel extensionModel;
    private final MavenProject mavenProject;

    public MuleMavenPluginEnricher(ExtensionModel extensionModel, MavenProject mavenProject, List<SharedLibraryDependency> sharedLibraries, String packagerVersion) {
        this.extensionModel = extensionModel;
        this.packagerVersion = packagerVersion;
        this.mavenProject = mavenProject;
        this.parameterizedSharedLibraries = sharedLibraries;
    }

    @Override
    public void generate(Model pomModel) {
        Xpp3Dom configuration = this.createConfiguration(pomModel);
        Plugin muleMavenPlugin = this.createPlugin(MAVEN_TOOLS_GROUP_ID, MULE_MAVEN_PLUGIN_ARTIFACT_ID, this.packagerVersion, configuration, Collections.emptyList(), true);
        this.getBuildNode(pomModel).addPlugin(muleMavenPlugin);
    }

    private Xpp3Dom createConfiguration(Model pomModel) {
        List<ExternalLibraryModel> externalLibs = this.getExternalLibs(this.extensionModel);
        if (externalLibs.isEmpty()) {
            return null;
        }
        this.validateParameterizedLibraries(externalLibs);
        if (this.parameterizedSharedLibraries.isEmpty()) {
            return null;
        }
        List<Dependency> sharedLibrariesDependencies = this.getSharedLibrariesDependencies(this.mavenProject.getDependencies());
        this.addSharedLibrariesDependencies(sharedLibrariesDependencies, pomModel);
        Xpp3Dom sharedLibraries = this.createSharedLibrariesDeclarations(sharedLibrariesDependencies);
        return this.createConfiguration(sharedLibraries);
    }

    private List<Dependency> getSharedLibrariesDependencies(List<Dependency> projectDependencies) {
        return projectDependencies.stream().filter(this::isDeclaredAsSharedLib).collect(Collectors.toList());
    }

    private void addSharedLibrariesDependencies(List<Dependency> sharedLibrariesDependencies, Model pomModel) {
        sharedLibrariesDependencies.stream().filter(sharedLibDep -> this.isNotAlreadyPresent(pomModel, (Dependency)sharedLibDep)).map(this::asCompileDependency).forEach(arg_0 -> ((Model)pomModel).addDependency(arg_0));
    }

    private boolean isNotAlreadyPresent(Model pomModel, Dependency sharedLibDependency) {
        return pomModel.getDependencies().stream().noneMatch(dep -> dep.getGroupId().equals(sharedLibDependency.getGroupId()) && dep.getArtifactId().equals(sharedLibDependency.getArtifactId()));
    }

    private Xpp3Dom createSharedLibrariesDeclarations(List<Dependency> sharedLibsDependencies) {
        Xpp3Dom sharedLibraries = new Xpp3Dom(SHARED_LIBRARIES_ELEMENT);
        sharedLibsDependencies.stream().filter(this::isDeclaredAsSharedLib).forEach(dependency -> sharedLibraries.addChild(this.createSharedLibraryDeclaration((Dependency)dependency)));
        return sharedLibraries;
    }

    private void validateParameterizedLibraries(List<ExternalLibraryModel> externalLibs) {
        List requiredLibs = externalLibs.stream().filter(l -> !l.isOptional()).map(ExternalLibraryModel::getName).collect(Collectors.toList());
        if (this.parameterizedSharedLibraries.size() < requiredLibs.size()) {
            StringBuilder sb = new StringBuilder().append("Missing SharedLibraries configuration. ").append("There are [").append(requiredLibs.size()).append("] required libraries ");
            if (this.parameterizedSharedLibraries.isEmpty()) {
                sb.append("but none was declared.");
            } else {
                sb.append("but only [").append(this.parameterizedSharedLibraries.size()).append("] ").append(this.parameterizedSharedLibraries.size() > 1 ? "were" : "was").append(" declared.");
            }
            sb.append("\n");
            sb.append("Required libraries are: ").append(requiredLibs).append(".");
            if (!this.parameterizedSharedLibraries.isEmpty()) {
                sb.append("\n").append("Provided libraries artifact-ids are: ").append(this.parameterizedSharedLibraries.stream().map(SharedLibraryDependency::getArtifactId).collect(Collectors.toList()));
            }
            sb.append("\n").append("Some tests may fail due to this missing libraries");
            LOGGER.warn(sb.toString());
        }
    }

    private List<ExternalLibraryModel> getExternalLibs(ExtensionModel extensionModel) {
        final ImmutableList.Builder libs = ImmutableList.builder().addAll((Iterable)extensionModel.getExternalLibraryModels());
        new IdempotentExtensionWalker(){

            protected void onConnectionProvider(ConnectionProviderModel model) {
                libs.addAll((Iterable)model.getExternalLibraryModels());
            }

            protected void onConfiguration(ConfigurationModel model) {
                libs.addAll((Iterable)model.getExternalLibraryModels());
            }
        }.walk(extensionModel);
        return libs.build();
    }

    private Xpp3Dom createSharedLibraryDeclaration(Dependency dependency) {
        Xpp3Dom groupId = new Xpp3Dom(GROUP_ID);
        groupId.setValue(dependency.getGroupId());
        Xpp3Dom artifactId = new Xpp3Dom(ARTIFACT_ID);
        artifactId.setValue(dependency.getArtifactId());
        Xpp3Dom sharedLibrary = new Xpp3Dom(SHARED_LIBRARY_ELEMENT);
        sharedLibrary.addChild(groupId);
        sharedLibrary.addChild(artifactId);
        return sharedLibrary;
    }

    private boolean isDeclaredAsSharedLib(Dependency dep) {
        return this.parameterizedSharedLibraries.stream().anyMatch(lib -> lib.getGroupId().equals(dep.getGroupId()) && lib.getArtifactId().equals(dep.getArtifactId()));
    }

    private Dependency asCompileDependency(Dependency originalDependency) {
        Dependency dependency = originalDependency.clone();
        dependency.setScope(COMPILE_SCOPE);
        return dependency;
    }
}

