/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.api;

import java.util.Optional;
import java.util.Properties;
import org.mule.munit.plugin.maven.ProductDiscoveryMode;

public class DiscoverRuntimes {
    public static final String DISCOVER_RUNTIMES_PRODUCT = "discoverRuntimes.product";
    public static final String DISCOVER_RUNTIMES_INCLUDE_SNAPSHOTS = "discoverRuntimes.includeSnapshots";
    public static final String DISCOVER_RUNTIMES_MIN_MULE_VERSION = "discoverRuntimes.minMuleVersion";
    public static final String DISCOVER_RUNTIMES_SKIP = "discoverRuntimes.skip";
    private ProductDiscoveryMode product;
    private String minMuleVersion;
    private boolean includeSnapshots = false;
    private boolean skip = false;

    public DiscoverRuntimes() {
    }

    private DiscoverRuntimes(ProductDiscoveryMode product, String minMuleVersion, boolean includeSnapshots, boolean skip) {
        this.product = product;
        this.minMuleVersion = minMuleVersion;
        this.includeSnapshots = includeSnapshots;
        this.skip = skip;
    }

    public Optional<String> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    public Optional<ProductDiscoveryMode> getProduct() {
        return Optional.ofNullable(this.product);
    }

    public boolean isIncludeSnapshots() {
        return this.includeSnapshots;
    }

    public boolean isSkipped() {
        return this.skip;
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private ProductDiscoveryMode product;
        private String minMuleVersion;
        private boolean includeSnapshots = false;
        private boolean skip;

        Builder() {
        }

        Builder from(DiscoverRuntimes discoverRuntimes) {
            if (discoverRuntimes == null) {
                this.skip = true;
                return this;
            }
            discoverRuntimes.getMinMuleVersion().ifPresent(minMuleVersion -> {
                this.minMuleVersion = minMuleVersion;
            });
            discoverRuntimes.getProduct().ifPresent(productDiscoveryMode -> {
                this.product = productDiscoveryMode;
            });
            this.includeSnapshots = discoverRuntimes.isIncludeSnapshots();
            this.skip = discoverRuntimes.isSkipped();
            return this;
        }

        Builder withProduct(ProductDiscoveryMode productDiscoveryMode) {
            this.product = productDiscoveryMode;
            return this;
        }

        Builder withMinMuleVersion(String minMuleVersion) {
            this.minMuleVersion = minMuleVersion;
            return this;
        }

        Builder includingSnapshots(Boolean includeSnapshots) {
            this.includeSnapshots = includeSnapshots;
            return this;
        }

        Builder skip(Boolean skip) {
            this.skip = skip;
            return this;
        }

        Builder withOverrides(Properties userProperties) {
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_INCLUDE_SNAPSHOTS)) {
                this.includeSnapshots = Boolean.valueOf(userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_INCLUDE_SNAPSHOTS));
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_PRODUCT)) {
                this.product = ProductDiscoveryMode.valueOf((String)userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_PRODUCT));
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_MIN_MULE_VERSION)) {
                this.minMuleVersion = userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_MIN_MULE_VERSION);
            }
            if (userProperties.containsKey(DiscoverRuntimes.DISCOVER_RUNTIMES_SKIP)) {
                this.skip = Boolean.valueOf(userProperties.getProperty(DiscoverRuntimes.DISCOVER_RUNTIMES_SKIP));
            }
            return this;
        }

        DiscoverRuntimes build() {
            return new DiscoverRuntimes(this.product, this.minMuleVersion, this.includeSnapshots, this.skip);
        }
    }
}

