/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model;


/**
 * This class exits to decouple the SDK model and the plain old model we use without SDK
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class UntypedEventError extends EventError {

  private Object exception;
  private Object cause;

  @Override
  public Object getCause() {
    return exception == null ? cause : exception;
  }

  @Override
  public void setCause(Object cause) {
    this.exception = cause;
  }
}
