package org.mule.munit.common.util;

import java.lang.reflect.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyExtractor {

  private static final String EXTRACTION_ERROR_MESSAGE = "Unable to extract class from proxy";
  private static Log logger = LogFactory.getLog(ProxyExtractor.class);

  /**
   * If the class is a proxy, it tries to extract the proxied class inside it. This is to handle cases like when using AOP to
   * proxy flows/subflows
   * 
   * @param obj the potential proxy
   * @return The same object if it is not a proxy or if it fails to extract the proxied class. When succesful, it returns the
   *         proxied class
   */
  public static Object extractIfProxy(Object obj) {
    if (obj instanceof Proxy) {
      try {
        Object proxiedClass = extract(obj);
        logger.debug("Extraction of class " + proxiedClass + " from proxy successful");
        return proxiedClass;
      } catch (NoSuchMethodException e) {
        logger.debug(EXTRACTION_ERROR_MESSAGE, e);
      } catch (IllegalAccessException e) {
        logger.debug(EXTRACTION_ERROR_MESSAGE, e);
      } catch (InvocationTargetException e) {
        logger.debug(EXTRACTION_ERROR_MESSAGE, e);
      } catch (NoSuchFieldException e) {
        logger.debug(EXTRACTION_ERROR_MESSAGE, e);
      }
    }
    return obj;
  }

  private static Object extract(Object obj)
      throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
    InvocationHandler invocationHandler = Proxy.getInvocationHandler(obj);
    Field advisedField = invocationHandler.getClass().getDeclaredField("advised");
    advisedField.setAccessible(true);
    Object advised = advisedField.get(invocationHandler);
    Method targetSourceMethod = advised.getClass().getMethod("getTargetSource");
    targetSourceMethod.setAccessible(true);
    Object targetSource = targetSourceMethod.invoke(advised);
    Field targetField = targetSource.getClass().getDeclaredField("target");
    targetField.setAccessible(true);
    return targetField.get(targetSource);
  }
}
