/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.modules.interceptor.processors.AbstractMessageProcessorInterceptor;
import org.mule.modules.interceptor.processors.MessageProcessorBehavior;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.adapters.MuleMessageDataTypeSetterAdapter;
import org.mule.munit.common.mocking.SamePayload;
import org.mule.munit.common.processor.MockedMessageProcessorManager;
import org.mule.munit.common.processor.MunitMessageProcessorCall;
import org.mule.munit.common.processor.SpyAssertion;
import org.mule.munit.common.processor.interceptor.MessageProcessorAttributesEvaluator;
import org.mule.munit.common.processors.InterceptingMessageProcessorHandler;
import org.mule.munit.common.util.ReusableByteArrayInputStream;

public class MunitMessageProcessorInterceptor
extends AbstractMessageProcessorInterceptor {
    private static transient Log logger = LogFactory.getLog(MunitMessageProcessorInterceptor.class);
    private String fileName;
    private String lineNumber;
    private EventCopyManager eventCopyManager;

    public Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        MuleEvent originalEvent = (MuleEvent)args[0];
        MuleEvent copyEvent = this.getCopyEvent(originalEvent);
        Object payloadCopy = originalEvent.getMessage().getPayload();
        MockedMessageProcessorManager manager = this.getMockedMessageProcessorManager(copyEvent.getMuleContext());
        MunitMessageProcessorCall messageProcessorCall = this.buildCall(obj, copyEvent);
        logger.debug((Object)("Executing MP: " + messageProcessorCall.getMessageProcessorId().getFullName() + "-[" + this.fileName + "|" + this.lineNumber + "]"));
        logger.debug((Object)"About to run Spy Before...");
        this.runSpyAssertion(manager.getBetterMatchingBeforeSpyAssertion(messageProcessorCall), originalEvent);
        this.registerCall(manager, messageProcessorCall);
        MessageProcessorBehavior behavior = manager.getBetterMatchingBehavior(messageProcessorCall);
        if (behavior != null) {
            logger.debug((Object)"Mock behavior found for message processor");
            originalEvent = this.invokeBehavior(behavior, manager, messageProcessorCall, originalEvent, payloadCopy);
            return this.handleInterceptingMessageProcessors(obj, originalEvent);
        }
        logger.debug((Object)"No mock behavior found for message processor, invoking original message processor");
        this.eventCopyManager.rollBackRequestContext();
        Object o = this.invokeSuper(obj, args, proxy);
        logger.debug((Object)"About to run Spy After...");
        this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), originalEvent);
        return o;
    }

    private void buildEventCopyManager(MuleEvent originalEvent) {
        this.eventCopyManager = new EventCopyManager(originalEvent);
    }

    private MuleEvent invokeBehavior(MessageProcessorBehavior behavior, MockedMessageProcessorManager manager, MunitMessageProcessorCall messageProcessorCall, MuleEvent originalEvent, Object payloadCopy) throws Throwable {
        boolean shouldReturnSamePayload = false;
        if (behavior.getExceptionToThrow() != null) {
            logger.debug((Object)"Mock behavior will throw exception");
            this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), originalEvent);
            throw behavior.getExceptionToThrow();
        }
        if (behavior.getMuleMessageTransformer() != null) {
            behavior.getMuleMessageTransformer().transform(originalEvent.getMessage());
            shouldReturnSamePayload = originalEvent.getMessage().getPayload() instanceof SamePayload;
        }
        this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), originalEvent);
        if (shouldReturnSamePayload) {
            originalEvent.getMessage().setPayload(payloadCopy);
        }
        return originalEvent;
    }

    protected Object handleInterceptingMessageProcessors(Object obj, MuleEvent event) throws Throwable {
        try {
            return new InterceptingMessageProcessorHandler(obj).invokeProcessNext(event);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof UnsupportedOperationException) {
                logger.debug((Object)"An UnsupportedOperationException was thrown when invoking the 'processNext' method", e.getTargetException());
                return event;
            }
            throw e;
        }
    }

    protected Object invokeSuper(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private void registerCall(MockedMessageProcessorManager manager, MunitMessageProcessorCall messageProcessorCall) {
        manager.addCall(messageProcessorCall);
    }

    private void runSpyAssertion(SpyAssertion spyAssertion, MuleEvent event) {
        if (spyAssertion == null) {
            logger.debug((Object)"No Spy was found to be run.");
            return;
        }
        logger.debug((Object)"Running Spy");
        MunitUtils.verifyAssertions(event, spyAssertion.getMessageProcessors());
    }

    private MunitMessageProcessorCall buildCall(Object originalMp, MuleEvent event) {
        MunitMessageProcessorCall call = new MunitMessageProcessorCall(this.id);
        call.setAttributes(MessageProcessorAttributesEvaluator.getEvaluatedAttributes(originalMp, this.attributes, event));
        call.setFlowConstruct(event.getFlowConstruct());
        call.setFileName(this.fileName);
        call.setLineNumber(this.lineNumber);
        return call;
    }

    protected MockedMessageProcessorManager getMockedMessageProcessorManager(MuleContext muleEvent) {
        return (MockedMessageProcessorManager)((Object)muleEvent.getRegistry().lookupObject(MockedMessageProcessorManager.ID));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public MuleEvent getCopyEvent(MuleEvent originalEvent) {
        this.buildEventCopyManager(originalEvent);
        return this.eventCopyManager.getCopyEvent();
    }

    public static class EventCopyManager {
        private MuleEvent originalEvent = null;
        private MuleEvent copyEvent = null;

        public EventCopyManager(MuleEvent originalEvent) {
            this.originalEvent = originalEvent;
        }

        public MuleEvent getCopyEvent() {
            if (null == this.copyEvent) {
                this.originalEvent = this.replacePayloadIfInputSteam();
                this.copyEvent = DefaultMuleEvent.copy((MuleEvent)this.originalEvent);
                MunitUtils.copyMessage(this.originalEvent.getMessage(), this.copyEvent.getMessage());
                RequestContext.setEvent((MuleEvent)this.copyEvent);
            }
            return this.copyEvent;
        }

        private MuleEvent replacePayloadIfInputSteam() {
            MuleMessage message = this.originalEvent.getMessage();
            if (message.getPayload() instanceof InputStream) {
                InputStream originalStream = (InputStream)message.getPayload();
                try {
                    ReusableByteArrayInputStream reusableStream = ReusableByteArrayInputStream.of(originalStream);
                    MuleMessageDataTypeSetterAdapter muleMessageDataTypeSetterAdapter = new MuleMessageDataTypeSetterAdapter(message);
                    muleMessageDataTypeSetterAdapter.setPayload(reusableStream, message.getDataType());
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to replace InputStream with ReusableByteArrayInputStream. Event will remain the same", (Throwable)e);
                }
            }
            return this.originalEvent;
        }

        public void rollBackRequestContext() {
            RequestContext.setEvent((MuleEvent)this.originalEvent);
        }
    }
}

